import request from "@/api/request";

//开始点名
// {
//   "securityStationIds": [
//     "string"
//   ],
//   "stationTypes": [
//     "string"
//   ]
// }
export function rollCalls(data) {
  return request({
    url: "/roll-calls",
    method: "POST",
    data,
  });
}

//点名轮询查询员工点名状态
export function getRollCallEmployees(data) {
  return request({
    url: "/roll-call-employees/search",
    method: "POST",
    data,
  });
}

//点名轮询查询-分组
export function getRollCallEmployeesGroup(data) {
  return request({
    url: "/roll-call-employees/group-search",
    method: "POST",
    data,
  });
}

//点名计划查询列表
export function searchRollCallPlans(params) {
  return request({
    url: "/roll-call-plans/search",
    method: "POST",
    data: params,
  });
}

//点名计划详情
export function getRollCallPlanDetail(planId) {
  return request({
    url: "/roll-call-plans/" + planId,
    method: "GET",
  });
}
//点名计划新增
export function createRollCallPlan(params) {
  return request({
    url: "/roll-call-plans",
    method: "POST",
    data: params,
  });
}
//点名计划修改
export function updateRollCallPlan(params) {
  return request({
    url: "/roll-call-plans/" + params.id,
    method: "PUT",
    data: params,
  });
}
//点名计划删除
export function deleteRollCallPlan(planId) {
  return request({
    url: "/roll-call-plans/" + planId,
    method: "DELETE",
  });
}

//获取点名状态
export function getRollCallStatus(params) {
  return request({
    url: "/roll-calls/status",
    method: "POST",
    data: params,
  });
}
