import axios from "axios";

// 创建axios实例
const instance = axios.create({
  // axios中请求配置有baseURL选项，表示请求URL公共部分
  baseURL: process.env.VUE_APP_HUAWEI_API,
  timeout: 60000,
});
instance.interceptors.request.use(
  async (config) => {
    // let accessToken = localStorage.getItem("huaweiToken");
    let accessToken = JSON.parse(localStorage.getItem("huaweiInfo"))?.accessToken;
    if (accessToken) {
      config.headers['Access-Token'] = accessToken;
    } else {
      let res = await axios.post(`${process.env.VUE_APP_API}/sync/api/hw/ivm/get-access-token`, {},
        {
          headers: {
            accessToken: localStorage.getItem("accessToken"),
          }
        })
      if (res.status === 200 && res.data) {
        // localStorage.setItem("huaweiToken", res.data.data.accessToken);
        localStorage.setItem("huaweiInfo", JSON.stringify(res.data.data));
        config.headers['Access-Token'] = res.data.data.accessToken;
      }
    }
    return config;
  },
  (err) => {
    return Promise.reject(err);
  }
);

instance.interceptors.response.use((response) => {
  const { status, data } = response;
  if (status === 200) {
    return data;
  }
});

export default instance;
