import request from "@/api/request";

// 项目路线列表
export function searchRoadmaps(params) {
  return request({
    url: "/project-roadmaps/search",
    method: "POST",
    data: params,
  });
}

// 新增路线
export function addRoadmaps(params) {
  return request({
    url: "/project-roadmaps",
    method: "POST",
    data: params,
  });
}

// 删除路线
export function delRoadmaps(id) {
  return request({
    url: "/project-roadmaps/" + id,
    method: "DELETE",
  });
}

// 修改路线
export function editRoadmaps(id, data) {
  return request({
    url: "/project-roadmaps/" + id,
    method: "PUT",
    data,
  });
}
