import request from "./request";

/**
 * 查询子组织账号详情
 * @param {Object} data
 * @param {String} data.subAccount
 * @returns {Promise<AxiosResponse<any>> | *}
 */
export const getAdminAccount = (data) => {
  return request({
    url: "/sapi/misc/virtualAccount/detail",
    method: "POST",
    data,
  });
};
export const doCreateAdminAccount = (data) => {
  return request({
    url: "/sapi/org/manage/create_virtualAccount",
    method: "POST",
    data,
  });
};
/**
 * 创建群组
 * @param {Object} data
 * @param {string} data.adminName -三级组织登录名 required
 * @param {string} data.name -群组名 required
 * @param {string[]} data.accountLists -账号数组
 * @returns {Promise<AxiosResponse<any>> | {status: number, data: number, message: string}}}}
 */
export const createGroup = (data) => {
  return request({
    url: "/sapi/dispatch/group/create",
    method: "POST",
    data,
  });
};
/**
 * 删除群组
 * @param {Object} data
 * @param {string} data.adminName -三级组织登录名 required
 * @param {number} data.gid -三级组织登录名 required
 * @returns {*}
 */
export const delGroup = (data) => {
  return request({
    url: "/sapi/dispatch/group/delete",
    method: "POST",
    data,
  });
};
/**
 * 调度群组加人
 * @param {Object} data
 * @param {string} data.adminName -三级组织登录名 required
 * @param {string[]} data.accountLists -账号数组 required
 * @param {number|null} data.gid -群组id required
 * @returns {Promise<AxiosResponse<any>> | {status: number, data: any, message: string}}}}
 */
export const addUsers = (data) => {
  return request({
    url: "/sapi/dispatch/users_add",
    method: "POST",
    data,
  });
};
/**
 * 调度群组删人
 * @param {Object} data
 * @param {string} data.adminName 三级组织登录名
 * @param {number|null} data.gid 群组id
 * @param {string[]} data.accountLists 账号数组
 * @returns {*}
 */
export const removeUsers = (data) => {
  return request({
    url: "/sapi/dispatch/users_delete",
    method: "POST",
    data,
  });
};
/**
 * 调度群组列表
 * @param {Object} data
 * @param {string} data.adminName -三级组织登录名
 * @returns {Promise<AxiosResponse<any>> | *}
 */
export const dispatchGroupList = (data) => {
  return request({
    url: "/sapi/dispatch/list",
    method: "POST",
    data,
  });
};
/**
 * 调度群组内成员列表
 * @param {Object} data
 * @param {number} data.gid
 */
export const dispatchUsers = (data) => {
  return request({
    url: "/sapi/dispatch/users",
    method: "POST",
    data,
  });
};
