import request from "@/api/request";

//查询保安人员信息
export function getEmployees(params) {
  return request({
    url: "/employees/search",
    method: "POST",
    data: params,
  });
}

//获取保安员详细信息
export function getEmployeeDetail(employeeId, deskType) {
  return request({
    url: "/employees/" + employeeId + "?desk-type=" + deskType,
    method: "GET",
  });
}

//查询保安人员轨迹信息
export function getEmployeesTrack(params) {
  return request({
    url: "/employees/" + params.employeeId + "/locations",
    method: "POST",
    data: {
      beginDate: params.beginDate,
      endDate: params.endDate,
    },
  });
}
