import request from "@/api/request";

//获取电子设备信息
export function getDevices(data) {
  return request({
    url: "/devices/search",
    method: "POST",
    data,
  });
}

//获取电子设备详细信息
export function getDeviceDetail(deviceId) {
  return request({
    url: "/devices/" + deviceId,
    method: "GET",
  });
}

export function deviceLocations(data) {
  return request({
    url: `/devices/${data.id}/locations`,
    method: "POST",
    data: {
      beginDate: data.beginDate,
      endDate: data.endDate,
    },
  });
}
