//隐藏敏感信息数据
import request from "@/api/request";
import axios from "axios";
// import axios from "axios";

export const hideNumber = (value) => {
  if (value) {
    value = value + "";
    let reg = /^(\d{2})(\d*)(\d{2})$/;
    let str = value.replace(reg, (a, b, c, d) => {
      return b + c.replace(/\d/g, "*") + d;
    });
    console.log(str);
    return str;
  } else {
    return value;
  }
};

//文字超出部分用省略号显示
export const textSlice = (value) => {
  if (value) {
    if (value.length > 10) {
      //最长固定显示10个字符
      return value.slice(0, 10) + "...";
    }
    return value;
  }
};

//视觉配置保存
// 参数{
//   "logo": "string",  文件名称
//   "title": "string"  标题
// }
export function visualSave(params) {
  return request({
    url: "/tenant/users/current/info",
    method: "PUT",
    data: params,
  });
}

// 图片文件上传
export function uploadFileApi(formData) {
  const url = process.env.VUE_APP_UPLOAD_FILE_API;
  return axios({
    url,
    method: "post",
    data: formData,
  });
}

// 获取图片配置信息
export function getVisualSetting() {
  return request({
    url: "/tenant/users/current/setting",
    method: "GET",
  });
}

export async function getHuaweiAccessToken(){
  let res = await axios.post(`${process.env.VUE_APP_API}/sync/api/hw/ivm/get-access-token`, {},
    {
      headers: {
        accessToken: localStorage.getItem("accessToken"),
      }
    })
  if (res.status === 200 && res.data) {
    localStorage.setItem("huaweiInfo", JSON.stringify(res.data.data));
  }
}