import { getConfig } from "@/utils";
import axios from "axios";

// 创建axios实例
const service = axios.create({
  timeout: 60000,
});

service.interceptors.request.use(
  async (config) => {

    if (config.map === "tianditu") {
      config.baseURL = "https://api.tianditu.gov.cn";
      config.params = {
        postStr: JSON.stringify({
          ...config.params,
        }),
        type: "query",
        tk: '18111c7ecf3f616faf921e930914e879',
      };
    } else {
      const { mapConfig } = await getConfig();
      const { server, key } = mapConfig;
      config.baseURL = server;
      if (config.method.toUpperCase() === "POST") {
        config.data = {
          ...config.data,
          key: process.env.VUE_APP_API.includes('zafkxt.jcgov.gov.cn')?'563310dfc6acdd373fd653ea98f9c860':key,
        };
      } else if (config.method.toUpperCase() === "GET") {
        config.params = {
          key: process.env.VUE_APP_API.includes('zafkxt.jcgov.gov.cn')?'563310dfc6acdd373fd653ea98f9c860':key,
          ...config.params,
        };
      }
    }
    return config;
  },
  (error) => {
    return Promise.reject(error);
  }
);

export const ipLocation = (params) => {
  return new Promise((resolve, reject) => {
    return service({
      url: "/v3/ip?",
      method: "GET",
      params,
    })
      .then((res) => {
        const { status, data } = res;
        if (status === 200) {
          resolve(data.city);
          return data.city;
        }
      })
      .catch((err) => {
        reject(new Error(err));
      });
  });
};

/**
 * 搜索POI
 * @param params
 * @returns {Promise<AxiosResponse<any>>}
 */
export const place = (params) => {
  return service({
    // url: "/v3/place/text?",
    url: "/v3/assistant/inputtips?",
    method: "GET",
    params,
  });
};

/**
 * 搜索POI-天地图
 * @param params
 * @returns {Promise<AxiosResponse<any>>}
 */
export const getPlaceByTiandi = (params) => {
  return service({
    url: "/v2/search?",
    method: "GET",
    map: "tianditu",
    params,
  });
};
