"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _clone = require('@turf/clone');
var _center = require('@turf/center');
var _centroid = require('@turf/centroid');
var _bbox = require('@turf/bbox');
var _rhumbbearing = require('@turf/rhumb-bearing');
var _rhumbdistance = require('@turf/rhumb-distance');
var _rhumbdestination = require('@turf/rhumb-destination');
var _meta = require('@turf/meta');
var _helpers = require('@turf/helpers');
var _invariant = require('@turf/invariant');
function transformScale(geojson, factor, options) {
  options = options || {};
  if (!_helpers.isObject.call(void 0, options)) throw new Error("options is invalid");
  const origin = options.origin || "centroid";
  const mutate = options.mutate || false;
  if (!geojson) throw new Error("geojson required");
  if (typeof factor !== "number" || factor <= 0)
    throw new Error("invalid factor");
  const originIsPoint = Array.isArray(origin) || typeof origin === "object";
  if (mutate !== true) geojson = _clone.clone.call(void 0, geojson);
  if (geojson.type === "FeatureCollection" && !originIsPoint) {
    _meta.featureEach.call(void 0, geojson, function(feature, index) {
      geojson.features[index] = scale(
        feature,
        factor,
        origin
      );
    });
    return geojson;
  }
  return scale(geojson, factor, origin);
}
function scale(feature, factor, origin) {
  const isPoint = _invariant.getType.call(void 0, feature) === "Point";
  const originCoord = defineOrigin(feature, origin);
  if (factor === 1 || isPoint) return feature;
  _meta.coordEach.call(void 0, feature, function(coord) {
    const originalDistance = _rhumbdistance.rhumbDistance.call(void 0, originCoord, coord);
    const bearing = _rhumbbearing.rhumbBearing.call(void 0, originCoord, coord);
    const newDistance = originalDistance * factor;
    const newCoord = _invariant.getCoords.call(void 0, 
      _rhumbdestination.rhumbDestination.call(void 0, originCoord, newDistance, bearing)
    );
    coord[0] = newCoord[0];
    coord[1] = newCoord[1];
    if (coord.length === 3) coord[2] *= factor;
  });
  delete feature.bbox;
  return feature;
}
function defineOrigin(geojson, origin) {
  if (origin === void 0 || origin === null) origin = "centroid";
  if (Array.isArray(origin) || typeof origin === "object")
    return _invariant.getCoord.call(void 0, origin);
  const bbox = geojson.bbox ? geojson.bbox : _bbox.bbox.call(void 0, geojson, { recompute: true });
  const west = bbox[0];
  const south = bbox[1];
  const east = bbox[2];
  const north = bbox[3];
  switch (origin) {
    case "sw":
    // @ts-expect-error undocumented, to be removed for v8 #techdebt
    case "southwest":
    // @ts-expect-error undocumented, to be removed for v8 #techdebt
    case "westsouth":
    // @ts-expect-error undocumented, to be removed for v8 #techdebt
    case "bottomleft":
      return _helpers.point.call(void 0, [west, south]);
    case "se":
    // @ts-expect-error undocumented, to be removed for v8 #techdebt
    case "southeast":
    // @ts-expect-error undocumented, to be removed for v8 #techdebt
    case "eastsouth":
    // @ts-expect-error undocumented, to be removed for v8 #techdebt
    case "bottomright":
      return _helpers.point.call(void 0, [east, south]);
    case "nw":
    // @ts-expect-error undocumented, to be removed for v8 #techdebt
    case "northwest":
    // @ts-expect-error undocumented, to be removed for v8 #techdebt
    case "westnorth":
    // @ts-expect-error undocumented, to be removed for v8 #techdebt
    case "topleft":
      return _helpers.point.call(void 0, [west, north]);
    case "ne":
    // @ts-expect-error undocumented, to be removed for v8 #techdebt
    case "northeast":
    // @ts-expect-error undocumented, to be removed for v8 #techdebt
    case "eastnorth":
    // @ts-expect-error undocumented, to be removed for v8 #techdebt
    case "topright":
      return _helpers.point.call(void 0, [east, north]);
    case "center":
      return _center.center.call(void 0, geojson);
    case void 0:
    case null:
    case "centroid":
      return _centroid.centroid.call(void 0, geojson);
    default:
      throw new Error("invalid origin");
  }
}
var turf_transform_scale_default = transformScale;



exports.default = turf_transform_scale_default; exports.transformScale = transformScale;
//# sourceMappingURL=index.cjs.map