// index.ts
import earcut from "earcut";
import { polygon } from "@turf/helpers";
function tesselate(poly) {
  if (!poly.geometry || poly.geometry.type !== "Polygon" && poly.geometry.type !== "MultiPolygon") {
    throw new Error("input must be a Polygon or MultiPolygon");
  }
  const fc = {
    type: "FeatureCollection",
    features: []
  };
  if (poly.geometry.type === "Polygon") {
    fc.features = processPolygon(poly.geometry.coordinates);
  } else {
    poly.geometry.coordinates.forEach(function(coordinates) {
      fc.features = fc.features.concat(processPolygon(coordinates));
    });
  }
  return fc;
}
function processPolygon(coordinates) {
  const data = flattenCoords(coordinates);
  const dim = 2;
  const result = earcut(data.vertices, data.holes, dim);
  const features = [];
  const vertices = [];
  result.forEach(function(vert, i2) {
    const index = result[i2];
    vertices.push([data.vertices[index * dim], data.vertices[index * dim + 1]]);
  });
  for (var i = 0; i < vertices.length; i += 3) {
    const coords = vertices.slice(i, i + 3);
    coords.push(vertices[i]);
    features.push(polygon([coords]));
  }
  return features;
}
function flattenCoords(data) {
  const dim = data[0][0].length, result = {
    vertices: [],
    holes: [],
    dimensions: dim
  };
  let holeIndex = 0;
  for (let i = 0; i < data.length; i++) {
    for (let j = 0; j < data[i].length; j++) {
      for (let d = 0; d < dim; d++) result.vertices.push(data[i][j][d]);
    }
    if (i > 0) {
      holeIndex += data[i - 1].length;
      result.holes.push(holeIndex);
    }
  }
  return result;
}
var turf_tesselate_default = tesselate;
export {
  turf_tesselate_default as default,
  tesselate
};
//# sourceMappingURL=index.js.map