"use strict";Object.defineProperty(exports, "__esModule", {value: true}); function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }// index.ts
var _earcut = require('earcut'); var _earcut2 = _interopRequireDefault(_earcut);
var _helpers = require('@turf/helpers');
function tesselate(poly) {
  if (!poly.geometry || poly.geometry.type !== "Polygon" && poly.geometry.type !== "MultiPolygon") {
    throw new Error("input must be a Polygon or MultiPolygon");
  }
  const fc = {
    type: "FeatureCollection",
    features: []
  };
  if (poly.geometry.type === "Polygon") {
    fc.features = processPolygon(poly.geometry.coordinates);
  } else {
    poly.geometry.coordinates.forEach(function(coordinates) {
      fc.features = fc.features.concat(processPolygon(coordinates));
    });
  }
  return fc;
}
function processPolygon(coordinates) {
  const data = flattenCoords(coordinates);
  const dim = 2;
  const result = _earcut2.default.call(void 0, data.vertices, data.holes, dim);
  const features = [];
  const vertices = [];
  result.forEach(function(vert, i2) {
    const index = result[i2];
    vertices.push([data.vertices[index * dim], data.vertices[index * dim + 1]]);
  });
  for (var i = 0; i < vertices.length; i += 3) {
    const coords = vertices.slice(i, i + 3);
    coords.push(vertices[i]);
    features.push(_helpers.polygon.call(void 0, [coords]));
  }
  return features;
}
function flattenCoords(data) {
  const dim = data[0][0].length, result = {
    vertices: [],
    holes: [],
    dimensions: dim
  };
  let holeIndex = 0;
  for (let i = 0; i < data.length; i++) {
    for (let j = 0; j < data[i].length; j++) {
      for (let d = 0; d < dim; d++) result.vertices.push(data[i][j][d]);
    }
    if (i > 0) {
      holeIndex += data[i - 1].length;
      result.holes.push(holeIndex);
    }
  }
  return result;
}
var turf_tesselate_default = tesselate;



exports.default = turf_tesselate_default; exports.tesselate = tesselate;
//# sourceMappingURL=index.cjs.map