import { BBox } from 'geojson';

/**
 * Takes a bounding box and calculates the minimum square bounding box that
 * would contain the input.
 *
 * @function
 * @param {BBox} bbox extent in [west, south, east, north] order
 * @returns {BBox} a square surrounding `bbox`
 * @example
 * const bbox = [-20, -20, -15, 0];
 * const squared = turf.square(bbox);
 *
 * //addToMap
 * const addToMap = [turf.bboxPolygon(bbox), turf.bboxPolygon(squared)]
 */
declare function square(bbox: BBox): BBox;

export { square as default, square };
