# @turf/projection

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## toMercator

Converts a WGS84 GeoJSON object into Mercator (EPSG:900913) projection

### Parameters

*   `geojson` **([GeoJSON][1] | [Position][2])** WGS84 GeoJSON object
*   `options` **[Object][3]?** Optional parameters (optional, default `{}`)

    *   `options.mutate` **[boolean][4]** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

### Examples

```javascript
var pt = turf.point([-71,41]);
var converted = turf.toMercator(pt);

//addToMap
var addToMap = [pt, converted];
```

Returns **[GeoJSON][1]** Projected GeoJSON

## toWgs84

Converts a Mercator (EPSG:900913) GeoJSON object into WGS84 projection

### Parameters

*   `geojson` **([GeoJSON][1] | [Position][2])** Mercator GeoJSON object
*   `options` **[Object][3]?** Optional parameters (optional, default `{}`)

    *   `options.mutate` **[boolean][4]** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

### Examples

```javascript
var pt = turf.point([-7903683.846322424, 5012341.663847514]);
var converted = turf.toWgs84(pt);

//addToMap
var addToMap = [pt, converted];
```

Returns **[GeoJSON][1]** Projected GeoJSON

[1]: https://tools.ietf.org/html/rfc7946#section-3

[2]: https://developer.mozilla.org/docs/Web/API/Position

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/projection
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
