# @turf/planepoint

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## planepoint

Takes a triangular plane as a polygon and a point within that triangle, and
returns the z-value at that point.

The Polygon should have properties `a`, `b`, and `c`
that define the values at its three corners. Alternatively, the z-values
of each triangle point can be provided by their respective 3rd coordinate
if their values are not provided as properties.

### Parameters

*   `point` **[Coord][1]** the Point for which a z-value will be calculated
*   `triangle` **[Feature][2]<[Polygon][3]>** a Polygon feature with three vertices

### Examples

```javascript
const point = turf.point([-75.3221, 39.529]);
// "a", "b", and "c" values represent the values of the coordinates in order.
const triangle = turf.polygon([[
  [-75.1221, 39.57],
  [-75.58, 39.18],
  [-75.97, 39.86],
  [-75.1221, 39.57]
]], {
  "a": 11,
  "b": 122,
  "c": 44
});

const zValue = turf.planepoint(point, triangle);
point.properties.zValue = zValue;

//addToMap
const addToMap = [triangle, point];
```

Returns **[number][4]** the z-value for `interpolatedPoint`

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[2]: https://tools.ietf.org/html/rfc7946#section-3.2

[3]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/planepoint
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
