"use strict";Object.defineProperty(exports, "__esModule", {value: true});var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};

// index.ts
var _invariant = require('@turf/invariant');
var _meta = require('@turf/meta');
var _pointtolinedistance = require('@turf/point-to-line-distance');
function nearestPointToLine(points, line, options = {}) {
  const units = options.units;
  const properties = options.properties || {};
  const pts = normalize(points);
  if (!pts.features.length) {
    throw new Error("points must contain features");
  }
  if (!line) {
    throw new Error("line is required");
  }
  if (_invariant.getType.call(void 0, line) !== "LineString") {
    throw new Error("line must be a LineString");
  }
  let dist = Infinity;
  let pt = null;
  _meta.featureEach.call(void 0, pts, (point) => {
    const d = _pointtolinedistance.pointToLineDistance.call(void 0, point, line, { units });
    if (d < dist) {
      dist = d;
      pt = point;
    }
  });
  if (pt) {
    pt.properties = __spreadValues(__spreadValues(__spreadValues({}, { dist }), pt.properties), properties);
  }
  return pt;
}
function normalize(points) {
  const features = [];
  const type = points.geometry ? points.geometry.type : points.type;
  switch (type) {
    case "GeometryCollection":
      _meta.geomEach.call(void 0, points, (geom) => {
        if (geom.type === "Point") {
          features.push({ type: "Feature", properties: {}, geometry: geom });
        }
      });
      return { type: "FeatureCollection", features };
    case "FeatureCollection":
      points.features = points.features.filter((feature) => {
        return feature.geometry.type === "Point";
      });
      return points;
    default:
      throw new Error("points must be a Point Collection");
  }
}
var turf_nearest_point_to_line_default = nearestPointToLine;



exports.default = turf_nearest_point_to_line_default; exports.nearestPointToLine = nearestPointToLine;
//# sourceMappingURL=index.cjs.map