# @turf/voronoi

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## voronoi

Takes a FeatureCollection of points, and a bounding box, and returns a FeatureCollection
of Voronoi polygons.

The Voronoi algorithim used comes from the d3-voronoi package.

**Parameters**

-   `points` **[FeatureCollection][1]&lt;[Point][2]>** to find the Voronoi polygons around.
-   `options` **[Object][3]** Optional parameters (optional, default `{}`)
    -   `options.bbox` **[Array][4]&lt;[number][5]>** clipping rectangle, in [minX, minY, maxX, MaxY] order. (optional, default `[-180,-85,180,-85]`)

**Examples**

```javascript
var options = {
  bbox: [-70, 40, -60, 60]
};
var points = turf.randomPoint(100, options);
var voronoiPolygons = turf.voronoi(points, options);

//addToMap
var addToMap = [voronoiPolygons, points];
```

Returns **[FeatureCollection][1]&lt;[Polygon][6]>** a set of polygons, one per input point.

[1]: https://tools.ietf.org/html/rfc7946#section-3.3

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[6]: https://tools.ietf.org/html/rfc7946#section-3.1.6

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/voronoi
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
