# @turf/polygon-smooth

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## polygonSmooth

Smooths a [Polygon][1] or [MultiPolygon][2]. Based on [Chaikin's algorithm][3].
Warning: may create degenerate polygons.

**Parameters**

-   `inputPolys` **([FeatureCollection][4] \| [Feature][5]&lt;([Polygon][6] \| [MultiPolygon][7])>)** (Multi)Polygon(s) to smooth
-   `options` **[Object][8]** Optional parameters (optional, default `{}`)
    -   `options.iterations` **[string][9]** THe number of times to smooth the polygon. A higher value means a smoother polygon. (optional, default `1`)

**Examples**

```javascript
var polygon = turf.polygon([[[11, 0], [22, 4], [31, 0], [31, 11], [21, 15], [11, 11], [11, 0]]]);

var smoothed = turf.polygonSmooth(polygon, {iterations: 3})

//addToMap
var addToMap = [smoothed, polygon];
```

Returns **[FeatureCollection][4]&lt;[Polygon][6]>** FeatureCollection containing the smoothed polygon/poylgons

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.7

[3]: http://graphics.cs.ucdavis.edu/education/CAGDNotes/Chaikins-Algorithm/Chaikins-Algorithm.html

[4]: https://tools.ietf.org/html/rfc7946#section-3.3

[5]: https://tools.ietf.org/html/rfc7946#section-3.2

[6]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[7]: https://tools.ietf.org/html/rfc7946#section-3.1.7

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[9]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/polygon-smooth
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
