/**
 * @fileOverview 需要计算所占x轴上的宽度的辅助类
 * @author sima.zhang1990@gmail.com
 * @author dxq613@gmail.com
 */
var Global = require('../../global');

var Util = require('../../util'); // 已经排序后的数据查找距离最小的


function findMinDistance(arr, scale) {
  var count = arr.length; // 日期类型的 values 经常上文本类型，所以需要转换一下

  if (Util.isString(arr[0])) {
    arr = arr.map(function (v) {
      return scale.translate(v);
    });
  }

  var distance = arr[1] - arr[0];

  for (var i = 2; i < count; i++) {
    var tmp = arr[i] - arr[i - 1];

    if (distance > tmp) {
      distance = tmp;
    }
  }

  return distance;
}

var SizeMixin = {
  getDefaultSize: function getDefaultSize() {
    var defaultSize = this.get('defaultSize');
    var viewTheme = this.get('viewTheme') || Global;

    if (!defaultSize) {
      var coord = this.get('coord');
      var xScale = this.getXScale();
      var xValues = xScale.values;
      var dataArray = this.get('dataArray');
      var count;

      if (xScale.isLinear && xValues.length > 1) {
        xValues.sort();
        var interval = findMinDistance(xValues, xScale);
        count = (xScale.max - xScale.min) / interval;

        if (xValues.length > count) {
          count = xValues.length;
        }
      } else {
        count = xValues.length;
      }

      var range = xScale.range;
      var normalizeSize = 1 / count;
      var widthRatio = 1;

      if (this.isInCircle()) {
        if (coord.isTransposed && count > 1) {
          // 极坐标下多层环图
          widthRatio = viewTheme.widthRatio.multiplePie;
        } else {
          widthRatio = viewTheme.widthRatio.rose;
        }
        /* if (dataArray.length > 1) {
          normalizeSize *= (range[1] - range[0]);
        } */

      } else {
        if (xScale.isLinear) {
          normalizeSize *= range[1] - range[0];
        }

        widthRatio = viewTheme.widthRatio.column; // 柱状图要除以2
      }

      normalizeSize *= widthRatio;

      if (this.hasAdjust('dodge')) {
        var _this$_getDodgeCfg = this._getDodgeCfg(dataArray),
            dodgeCount = _this$_getDodgeCfg.dodgeCount,
            dodgeRatio = _this$_getDodgeCfg.dodgeRatio;

        normalizeSize = normalizeSize / dodgeCount;

        if (dodgeRatio > 0) {
          normalizeSize = dodgeRatio * normalizeSize / widthRatio;
        }
      }

      defaultSize = normalizeSize;
      this.set('defaultSize', defaultSize);
    }

    return defaultSize;
  },
  _getDodgeCfg: function _getDodgeCfg(dataArray) {
    var adjusts = this.get('adjusts');
    var dodgeBy;
    var dodgeRatio;
    var count = dataArray.length;
    Util.each(adjusts, function (adjust) {
      if (adjust.type === 'dodge') {
        dodgeBy = adjust.dodgeBy;
        dodgeRatio = adjust.dodgeRatio;
      }
    });

    if (dodgeBy) {
      var mergeData = Util.Array.merge(dataArray);
      var values = Util.Array.values(mergeData, dodgeBy);
      count = values.length;
    }

    return {
      dodgeCount: count,
      dodgeRatio: dodgeRatio
    };
  },
  getDimWidth: function getDimWidth(dimName) {
    var coord = this.get('coord');
    var start = coord.convertPoint({
      x: 0,
      y: 0
    });
    var end = coord.convertPoint({
      x: dimName === 'x' ? 1 : 0,
      y: dimName === 'x' ? 0 : 1
    });
    var width = 0;

    if (start && end) {
      width = Math.sqrt(Math.pow(end.x - start.x, 2) + Math.pow(end.y - start.y, 2));
    }

    return width;
  },
  _getWidth: function _getWidth() {
    var coord = this.get('coord');
    var width; // x轴的长度

    if (this.isInCircle() && !coord.isTransposed) {
      // 极坐标下 width 为弧长
      width = (coord.endAngle - coord.startAngle) * coord.radius;
    } else {
      width = this.getDimWidth('x'); // 不需要判断transpose
    }

    return width;
  },
  _toNormalizedSize: function _toNormalizedSize(size) {
    var width = this._getWidth();

    return size / width;
  },
  _toCoordSize: function _toCoordSize(normalizeSize) {
    var width = this._getWidth();

    return width * normalizeSize;
  },
  getNormalizedSize: function getNormalizedSize(obj) {
    var size = this.getAttrValue('size', obj);

    if (Util.isNil(size)) {
      size = this.getDefaultSize();
    } else {
      size = this._toNormalizedSize(size);
    }

    return size;
  },
  getSize: function getSize(obj) {
    var size = this.getAttrValue('size', obj);

    if (Util.isNil(size)) {
      var normalizeSize = this.getDefaultSize();
      size = this._toCoordSize(normalizeSize);
    }

    return size;
  }
};
module.exports = SizeMixin;