function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview Venn Diagram
 * @author leungwensen@gmail.com
 */
var GeomBase = require('./base');

var Util = require('../util');

var SizeMixin = require('./mixin/size');

require('./shape/violin');

var Violin = /*#__PURE__*/function (_GeomBase) {
  _inheritsLoose(Violin, _GeomBase);

  var _proto = Violin.prototype;

  /**
   * get default configuration
   * @protected
   * @return {Object} configuration
   */
  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _GeomBase.prototype.getDefaultCfg.call(this);

    cfg.type = 'violin';
    cfg.shapeType = 'violin';
    cfg.generatePoints = true; // super.draw(data, container, shapeFactory, index);

    return cfg;
  };

  function Violin(cfg) {
    var _this;

    _this = _GeomBase.call(this, cfg) || this;
    Util.assign(_assertThisInitialized(_this), SizeMixin);
    return _this;
  }

  _proto.createShapePointsCfg = function createShapePointsCfg(obj) {
    var self = this;

    var cfg = _GeomBase.prototype.createShapePointsCfg.call(this, obj);

    cfg.size = self.getNormalizedSize(obj);
    var sizeField = self.get('_sizeField');
    cfg._size = obj._origin[sizeField];
    return cfg;
  };

  _proto.clearInner = function clearInner() {
    _GeomBase.prototype.clearInner.call(this);

    this.set('defaultSize', null);
  };

  _proto._initAttrs = function _initAttrs() {
    var self = this;
    var attrOptions = self.get('attrOptions');
    var sizeField = attrOptions.size ? attrOptions.size.field : self.get('_sizeField') ? self.get('_sizeField') : 'size';
    self.set('_sizeField', sizeField);
    delete attrOptions.size;

    _GeomBase.prototype._initAttrs.call(this);
  };

  return Violin;
}(GeomBase);

var ViolinDodge = /*#__PURE__*/function (_Violin) {
  _inheritsLoose(ViolinDodge, _Violin);

  function ViolinDodge() {
    return _Violin.apply(this, arguments) || this;
  }

  var _proto2 = ViolinDodge.prototype;

  _proto2.getDefaultCfg = function getDefaultCfg() {
    var cfg = _Violin.prototype.getDefaultCfg.call(this);

    cfg.hasDefaultAdjust = true;
    cfg.adjusts = [{
      type: 'dodge'
    }];
    return cfg;
  };

  return ViolinDodge;
}(Violin);

Violin.Dodge = ViolinDodge;
GeomBase.Violin = Violin;
GeomBase.ViolinDodge = ViolinDodge;
module.exports = Violin;