function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

/**
 * @fileOverview 边，用于关系图的边
 * @author dxq613@gmail.com
 */
var GeomBase = require('./base');

require('./shape/edge');

var Edge = /*#__PURE__*/function (_GeomBase) {
  _inheritsLoose(Edge, _GeomBase);

  function Edge() {
    return _GeomBase.apply(this, arguments) || this;
  }

  var _proto = Edge.prototype;

  /**
   * 获取默认的配置属性
   * @protected
   * @return {Object} 默认属性
   */
  _proto.getDefaultCfg = function getDefaultCfg() {
    var cfg = _GeomBase.prototype.getDefaultCfg.call(this);

    cfg.type = 'edge';
    cfg.shapeType = 'edge';
    cfg.generatePoints = true;
    return cfg;
  };

  return Edge;
}(GeomBase);

GeomBase.Edge = Edge;
module.exports = Edge;