/**
 * @fileOverview The controller of coordinate
 * @author sima.zhang
 */
var Util = require('../../util');

var Coord = require('@antv/coord/lib/');

var CoordController = /*#__PURE__*/function () {
  function CoordController(option) {
    this.type = 'rect';
    this.actions = [];
    this.cfg = {};
    Util.mix(this, option);
    this.option = option || {};
  }

  var _proto = CoordController.prototype;

  _proto.reset = function reset(coordOption) {
    this.actions = coordOption.actions || [];
    this.type = coordOption.type;
    this.cfg = coordOption.cfg;
    this.option.actions = this.actions;
    this.option.type = this.type;
    this.option.cfg = this.cfg;
    return this;
  };

  _proto._execActions = function _execActions(coord) {
    var actions = this.actions;
    Util.each(actions, function (action) {
      var m = action[0];
      coord[m](action[1], action[2]);
    });
  };

  _proto.hasAction = function hasAction(actionName) {
    var actions = this.actions;
    var rst = false;
    Util.each(actions, function (action) {
      if (actionName === action[0]) {
        rst = true;
        return false;
      }
    });
    return rst;
  }
  /**
   * 创建坐标系对象
   * @param  {Object} start 坐标系起始点
   * @param  {Object} end   坐标系结束点
   * @return {Function} 坐标系的构造函数
   */
  ;

  _proto.createCoord = function createCoord(start, end) {
    var self = this;
    var type = self.type;
    var cfg = self.cfg;
    var C; // 构造函数

    var coord;
    var coordCfg = Util.mix({
      start: start,
      end: end
    }, cfg);

    if (type === 'theta') {
      // definition of theta coord
      C = Coord.Polar;

      if (!self.hasAction('transpose')) {
        self.transpose(); // 极坐标，同时transpose
      }

      coord = new C(coordCfg);
      coord.type = type;
    } else {
      C = Coord[Util.upperFirst(type || '')] || Coord.Rect;
      coord = new C(coordCfg);
    }

    self._execActions(coord);

    return coord;
  };

  _proto.rotate = function rotate(angle) {
    angle = angle * Math.PI / 180;
    this.actions.push(['rotate', angle]);
    return this;
  };

  _proto.reflect = function reflect(dim) {
    this.actions.push(['reflect', dim]);
    return this;
  };

  _proto.scale = function scale(sx, sy) {
    this.actions.push(['scale', sx, sy]);
    return this;
  };

  _proto.transpose = function transpose() {
    this.actions.push(['transpose']);
    return this;
  };

  return CoordController;
}();

module.exports = CoordController;