package com.bcxin.platform.service.product.impl;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.product.ConfigProductBuyMode;
import com.bcxin.platform.dto.product.ConfigProductInfoDto;
import com.bcxin.platform.dto.product.ConfigProductTypeDto;
import com.bcxin.platform.dto.product.ProductQueryDto;
import com.bcxin.platform.mapper.product.ConfigProductMapper;
import com.bcxin.platform.service.product.ConfigProductService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 配置产品
 *
 * @author llc
 * @date 2020-01-15
 */
@Service
@Transactional("transactionManager")
public class ConfigProductServiceImpl implements ConfigProductService {

    @Resource
    private ConfigProductMapper configProductMapper;
    /**
     * 获取产品列表
     *
     * @return
     * @author llc
     * @date 2020-01-15
     */
    @Override
    public Result getProductList(ProductQueryDto dto) throws V5BusinessException {
        if (StringUtils.isEmpty(dto.getProductCategoryType())) {
            return Result.fail("产品范畴不能为空");
        }
        if (StringUtils.isEmpty(dto.getProductServiceType())) {
            return Result.fail("产品服务类型不能为空");
        }
        /*** 产品类型列表 ***/
        List<ConfigProductTypeDto> productTypeList = configProductMapper.getProductTypeList(dto.getProductCategoryType(),dto.getProductServiceType());

        /*** 产品列表 ***/
        List<ConfigProductInfoDto> productInfoList = new ArrayList<>();
        if(productTypeList != null && productTypeList.size()>0){

            List<String> productTypeStrList = new ArrayList<>();

            for(ConfigProductTypeDto productTypeDto : productTypeList){
                productTypeStrList.add(productTypeDto.getProductType());
            }
            /*** 产品列表 ***/
            productInfoList = configProductMapper.getgProductInfoByTypeList(productTypeStrList);
        }

        /*** 产品购买方式列表 ***/
        List<ConfigProductBuyMode> productBuyModeList = new ArrayList<>();
        if(productInfoList != null && productInfoList.size()>0){

            List<String> productIdList = new ArrayList<>();

            for(ConfigProductInfoDto productInfoDto : productInfoList){
                productIdList.add(productInfoDto.getProductId());
            }
            /*** 产品列表 ***/
            productBuyModeList = configProductMapper.getProductBuyModeByIdList(productIdList);
        }

        /*** 处理产品列表 ***/
        if (productBuyModeList != null && productBuyModeList.size() > 0) {
            for (ConfigProductInfoDto productInfoDto : productInfoList) {
                /*** 定义购买方式列表 ***/
                List<ConfigProductBuyMode> list = new ArrayList<>();
                for (ConfigProductBuyMode configProductBuyMode : productBuyModeList) {
                    /*** 如果购买方式的产品ID等于产品ID ***/
                    if (configProductBuyMode.getProductId().equals(productInfoDto.getProductId())) {
                        list.add(configProductBuyMode);
                    }
                }
                productInfoDto.setProductBuyModeList(list);
            }
        }

        /*** 处理产品类型列表 ***/
        if (productInfoList != null && productInfoList.size() > 0) {
            for (ConfigProductTypeDto productTypeDto : productTypeList) {
                /*** 定义购买方式列表 ***/
                List<ConfigProductInfoDto> list = new ArrayList<>();
                for (ConfigProductInfoDto productInfoDto : productInfoList) {
                    /*** 如果购买方式的产品ID等于产品ID ***/
                    if (productInfoDto.getProductType().equals(productTypeDto.getProductType())) {
                        list.add(productInfoDto);
                    }
                }
                productTypeDto.setProductInfoList(list);
            }
        }
        return Result.success(Result.SUCCESS_QUERY_MSG,productTypeList);
    }
}