package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.DateValue;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.FactorGroup;
import com.bcxin.platform.common.utils.validator.group.OneGroup;
import com.bcxin.platform.common.utils.validator.group.TwoGroup;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 考勤班次对象 tb_attend_shift
 * 
 * @author lin
 * @date 2021-08-10
 */
@Data
public class AttendShift extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 考勤班次ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /** 是否启用 1是0否 */
    @Excel(name = "是否启用 1是0否")
    @NotBlank(message="是否启用不能为空", groups = {OneGroup.class, TwoGroup.class})
    private String active;

    @Excel(name = "班次类型 1计时班次 2 计次班次")
    @NotBlank(message="班次类型不能为空", groups = {AddGroup.class})
    private String shiftType;

    /** 是否跨天 1是0否 */
    @Excel(name = "是否跨天 1是0否")
    private String crossDay;

    /** 班次名称 */
    @Excel(name = "班次名称")
    @NotBlank(message="班次名称不能为空", groups = {OneGroup.class,TwoGroup.class})
    private String shiftName;

    /** 上班时间 */
    @Excel(name = "上班时间")
    @NotBlank(message="上班时间不能为空", groups = {OneGroup.class,TwoGroup.class})
    @DateValue(message = "上班时间格式错误",format = "HH:mm",groups = {OneGroup.class,TwoGroup.class})
    private String startTime;

    /** 下班时间 */
    @Excel(name = "下班时间")
    @NotBlank(message="下班时间不能为空", groups = {OneGroup.class})
    @DateValue(message = "下班时间格式错误",format = "HH:mm",groups = {OneGroup.class})
    private String endTime;

    /** 班次总时长 */
    @Excel(name = "班次总时长")
    //@NotNull(message="班次总时长不能为空", groups = {OneGroup.class,TwoGroup.class})
    private Double shiftHour;


    /** 是否需要休息 1是0否*/
    @Excel(name = "是否需要休息")
    @NotBlank(message="是否需要休息不能为空", groups = {OneGroup.class})
    private String needRest;

    /** 休息开始时间 */
    @Excel(name = "休息开始时间")
    @NotBlank(message="休息开始时间不能为空", groups = {FactorGroup.class})
    @DateValue(message = "休息开始时间格式错误",format = "HH:mm",groups = {FactorGroup.class})
    private String restStart;

    /** 休息结束时间 */
    @Excel(name = "休息结束时间")
    @NotBlank(message="休息结束时间不能为空", groups = {FactorGroup.class})
    @DateValue(message = "休息结束时间格式错误",format = "HH:mm",groups = {FactorGroup.class})
    private String restEnd;

    /**  休息时长 */
    //@NotNull(message="休息时长不能为空", groups = {OneGroup.class,TwoGroup.class})
    private Double restHour;

    /** 部门ID */
    @Excel(name = "部门ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long deptId;

    /** 考勤套ID */
    @Excel(name = "考勤套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="考勤套不能为空", groups = {OneGroup.class,TwoGroup.class})
    private Long attendId;

    /** 公司ID */
    @Excel(name = "公司ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

}
