package com.bcxin.platform.components;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class CompleteFurtherUtils {
    public static <T> void execute(Collection<T> collection, Consumer<T> consumer) {
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            Collection<CompletableFuture<Void>> futures =
                    collection.stream()
                            .map(key -> {
                                return CompletableFuture.runAsync(() -> {
                                    consumer.accept(key);
                                    return;
                                }, executor);
                            }).collect(Collectors.toList());

            CompletableFuture<Void> allCF =
                    CompletableFuture.allOf(futures.toArray(new CompletableFuture[collection.size()]));

            Object result = allCF.join();
        } finally {
            executor.shutdown();
        }
    }

    public static <T> void executeAsync(Collection<T> collection, Consumer<T> consumer) {
        Collection<CompletableFuture<Void>> futures =
                collection.stream()
                        .map(key -> {
                            return CompletableFuture.runAsync(() -> {
                                consumer.accept(key);
                                return;
                            });
                        }).collect(Collectors.toList());
    }
}
