package com.bcxin.platform.service.order;


import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.dto.order.ComOrderDto;
import com.bcxin.platform.dto.order.ComOrderVo;

import java.util.List;
import java.util.Map;

/**
 * 配置产品
 *
 * @author llc
 * @date 2020-01-15
 */
public interface ComOrderService {


    /**
     * 校验订单
     * @return
     * @author llc
     * @date 2020-01-20
     */
    Result checkOrder(ComOrderDto dto) throws V5BusinessException;


    /**
     * 提交订单
     * @return
     * @author llc
     * @date 2020-01-15
     */
    Result saveOrder(ComOrderDto dto) throws V5BusinessException;


    Result getOrderList(ComOrderDto dto) throws V5BusinessException;

    /**
     * <b> 根据被分配机构id查询资源列 </b>
     * @author ZXF
     * @create 2020/05/25 0025 17:50
     * @version
     * @注意事项 </b>
     */
    List<Map<String,String>> getOrderDetailListByAssignedOrgId(ComOrderDto dto) throws PlatFormBusinessException;

    List<ComOrderVo> orderList(ComOrderVo dto) throws PlatFormBusinessException;

    /**
     * 更改订单部署状态
     * @return
     * @author llc
     * @date 2020-01-17
     */
    Result changeDeployStatus(ComOrderDto dto) throws Exception;

    /**
     * 获取统计信息
     * @author wangjianjun
     * @date 2020/4/1
     */
    Result getOrderStatistic(ComOrderDto dto);

    /**
     * <b> 根据订单Id查询订单支付信息 </b>
     * @author ZXF
     * @create 2020/06/01 0001 15:47
     * @version
     * @注意事项 </b>
     */
    Object findOrderPayListByOrderId(ComOrderDto dto);

    /**
     * <b> 采购资源 </b>
     * @author ZXF
     * @create 2020/05/20 0020 14:46
     * @version
     * @注意事项 </b>
     */
    Result purchasingResource(ComOrderDto dto,Long perId) throws PlatFormBusinessException;

    /**
     * <b> 采购资源确认支付 </b>
     * @author ZXF
     * @create 2020/05/20 0020 14:46
     * @version
     * @注意事项 </b>
     */
    Result orderConfirmPay(ComOrderVo dto,Long perId) throws PlatFormBusinessException;

    /**
     * <b> 分配资源 </b>
     * @author ZXF
     * @create 2020/05/20 0020 14:47
     * @version
     * @注意事项 </b>
     */
    Result allocationResource(ComOrderDto dto,Long perId) throws PlatFormBusinessException;

    /**
     * <b> 定时查询隔天到期的企业资源，请求接口做删除 </b>
     * @author ZXF
     * @create 2020/05/28 0028 10:51
     * @version
     * @注意事项 </b>
     */
    Result delComResource() throws PlatFormBusinessException;
}