package com.bcxin.platform.service.insurance.manage;


import cn.hutool.core.bean.BeanUtil;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.wallet.ComWalletAccount;
import com.bcxin.platform.domain.wallet.ComWalletChangeEvent;
import com.bcxin.platform.dto.SearchParamDTO;
import com.bcxin.platform.dto.insurance.ComInsDTO;
import com.bcxin.platform.dto.insurance.ComInsPrincipalDTO;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Maps;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.*;

public interface ComInsManageService {

    /**
     * 企业保险查询分页
     * @param dto
     * @return
     */
    public List<Map<String,Object>> pageComInsList(ComInsDTO dto);

    /**
     * 查询企业保险信息
     * @param dto
     * @return
     * @throws BusinessException
     */
    public Result getComInsInfo(ComInsDTO dto) throws V5BusinessException;

    public Map<String, Object> getComInsInfo(String comInsId) throws V5BusinessException;

    /**
     * <b> 根据企业ID，查询保险负责人列 </b>
     * @author ZXF
     * @create 2019/05/17 0017 16:45
     * @version
     * @注意事项 </b>
     */
    public List<Map> selectPrincipalByComId(ComInsPrincipalDTO dto);

    /**
     * <b> 修改在保人数 </b>
     * @author ZXF
     * @create 2019/12/27 0027 16:09
     * @version
     * @注意事项 </b>
     */
    public Result updatePerNum(ComInsDTO dto);

    /**
     * <b> 保险推荐报表下载 </b>
     * @author ZXF
     * @create 2020/04/07 0007 16:31
     * @version
     * @注意事项 </b>
     */
    public void downInsSchedule(HttpServletResponse response);
}
