package com.bcxin.platform.service.attend;

import com.bcxin.platform.domain.attend.AttendPer;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.app.AppAttendPerDto;
import com.bcxin.platform.dto.attend.AttendPerDto;

import java.util.List;

/**
 * 考勤人员Service接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendPerService{

    /**
     * 查询考勤人员
     * 
     * @param id 考勤人员ID
     * @return 考勤人员
     */
    AttendPer findById(Long id);

    /**
     * 查询考勤人员列表
     * 
     * @param attendPer 考勤人员
     * @return 考勤人员集合
     */
    List<AttendPerDto> selectList(AttendPerDto attendPer);


    /**
     * 编辑考勤人员
     * 
     * @param attendPer 考勤人员
     * @return 结果
     */
    int update(AttendPer attendPer);

    /**
     * 批量删除考勤人员
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    List<PerBaseInfo> getDepartPersonList(AttendPerDto searchDto);

    List<AppAttendPerDto> selectListForPer(AppAttendPerDto perDto);

    int save(AttendPer attendPer) throws CloneNotSupportedException;

    List<AppAttendPerDto> getUnSchedulPersonList(AppAttendPerDto perDto);

    int deleteByPerIds(AppAttendPerDto attendPerDto);
}
