package com.bcxin.platform.mapper.meeting;

import com.bcxin.platform.domain.product.PoliceHuaweiMeetMatch;
import com.bcxin.platform.util.CrudDao;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * <b> 公安华为云会议映射 </b>
 * @author ZXF
 * @create 2020/05/22 0022 16:10
 * @version
 * @注意事项 </b>
 */
@Component
public interface PoliceHuaweiMeetMatchMapper extends CrudDao<PoliceHuaweiMeetMatch> {

    /**
     * <b> 获取公安华为云会议映射关系 </b>
     * @author ZXF
     * @create 2020/05/20 0020 14:58
     * @version
     * @注意事项 </b>
     */
    PoliceHuaweiMeetMatch getPoliceHuaweiMeetMatchByPoliceId(@Param("policeId") Long policeId);

    String getManageUserNameByPoliceId(@Param("policeId") Long policeId);

    int delete(@Param("policeId") Long policeId);

    List<Map> findPoliceHuaweiMeetMatchList();

    int selectCount(@Param("policeId") Long policeId);
}