package com.bcxin.platform.dto.app;

import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.domain.attend.AttendShift;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 考勤套对象 tb_attend
 * 
 * @author lin
 * @date 2021-08-10
 */
@Data
public class AppAttendEditDto  extends Attend {

    /**
     * 考勤人员id
     */
    @NotEmpty(message="考勤人员不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String[] perIds;

    /**
     * 考勤班次
     */
    @NotEmpty(message="考勤班次不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private List<AttendShift> shiftList;

}
