package com.bcxin.platform.domain.product;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 产品优惠券
 * 
 * @author llc
 * @date 2020-12-16
 */
@Data
@TableName("product_coupon")
public class ProductCoupon extends BaseEntity<ProductCoupon> {

	/** 产品优惠券ID(优惠券码) */
	@ApiModelProperty(value = "产品优惠券ID(优惠券码)")
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long productCouponId;

	/** 产品范畴类型 */
	@ApiModelProperty(value = "产品范畴类型")
	private String productCategoryType;

	/** 优惠券名称 */
	@ApiModelProperty(value = "优惠券名称")
	private String name;

	/** 优惠券状态 */
	@ApiModelProperty(value = "优惠券状态")
	private String couponStatus;

	/** 优惠方式 */
	@ApiModelProperty(value = "优惠方式")
	private String discountWay;

	/** 优惠值 */
	@ApiModelProperty(value = "优惠值")
	private BigDecimal discountValue;

	/** 开始时间 */
	@ApiModelProperty(value = "开始时间")
	private Date startTime;

	/** 过期天数 */
	@ApiModelProperty(value = "过期天数")
	private Integer expireDays;

	/** 过期时间 */
	@ApiModelProperty(value = "过期时间")
	private Date expireTime;

	/** 备注 */
	@ApiModelProperty(value = "备注")
	private String remark;

	/** 过期时间 */
	@ApiModelProperty(value = "使用时间")
	private Date useTime;

	/** 企业订单ID */
	@ApiModelProperty(value = "企业订单ID")
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long comOrderId;


}