package com.bcxin.platform.domain.grant;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 人员联名卡
 * 
 * @author llc
 * @date 2020-07-21
 */
@Data
@TableName("per_jointly_card")
public class PerJointlyCard extends BaseEntity<PerJointlyCard> {

	/** 人员ID */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	/** 是否激活 */
	@ApiModelProperty(value = "是否激活")
	private String isActive;

	/** 激活时间 */
	@ApiModelProperty(value = "激活时间")
	private String activeTime;

	/** 开卡时间 */
	@ApiModelProperty(value = "开卡时间")
	private String openCardTime;

	/** 银行编码 */
	@ApiModelProperty(value = "银行编码")
	private String bankCode;

	/** 银行网点 */
	@ApiModelProperty(value = "银行网点")
	private String bankOutlets;

	/** 银行账户类型 */
	@ApiModelProperty(value = "银行账户类型")
	private String bankAccountType;

	/** 银行行号 */
	@ApiModelProperty(value = "银行行号")
	private String bankNo;

	/** 银行卡号 */
	@ApiModelProperty(value = "银行卡号")
	private String bankCardNo;

	/** 银行账户状态 */
	@ApiModelProperty(value = "银行账户状态")
	private String bankAccountStatus;

	/** 注销时间 */
	@ApiModelProperty(value = "注销时间")
	private String cancelTime;

	/** 注销原因 */
	@ApiModelProperty(value = "注销原因")
	private String cancelReason;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

}