package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 考勤打卡日历套-日历对象 tb_attend_calendar_rest
 * 
 * @author lin
 * @date 2021-08-10
 */
@Data
public class AttendCalendarRest extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /** 日历ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="日历套id不能为空", groups = {UpdateGroup.class})
    private Long id;

    /** 日历类型 1-休息日 2-法定假日 */
    @Excel(name = "日历类型")
    @NotBlank(message="日历类型不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String calendarType;

    /** 开始日期 */
    @NotBlank(message="开始日期不能为空", groups = {AddGroup.class,UpdateGroup.class})
    @Excel(name = "开始日期", width = 30, dateFormat = "yyyy-MM-dd")
    private String startDate;

    /** 结束日期 */
    @NotBlank(message="结束日期不能为空", groups = {AddGroup.class,UpdateGroup.class})
    @Excel(name = "结束日期", width = 30, dateFormat = "yyyy-MM-dd")
    private String endDate;

    /** 日历套ID */
    @Excel(name = "日历套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="日历套id不能为空", groups = {AddGroup.class,UpdateGroup.class})
    private Long calendarId;

}
