/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.wallet.manage;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.wallet.ComWalletAccount;
import com.bcxin.platform.domain.wallet.ComWalletChangeEvent;
import com.bcxin.platform.dto.SearchParamDTO;
import com.bcxin.platform.mapper.wallet.manage.ComWalletManageMapper;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.wallet.manage.ComWalletManageService;
import com.bcxin.platform.util.DateUtils;
import com.bcxin.platform.util.JwtUtil;
import com.bcxin.platform.util.constants.PaymentServiceConst;
import com.bcxin.platform.util.excel.ExcelUtil;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="comWalletManageService")
public class ComWalletManageServiceImpl
implements ComWalletManageService {
    private Logger logger = LoggerFactory.getLogger(ComWalletManageServiceImpl.class);
    @Autowired
    private ComWalletManageMapper comWalletMapper;
    @Autowired
    private CommonService commonService;

    @Override
    public List<Map<String, Object>> pageComWalletList(SearchParamDTO dto) {
        return this.comWalletMapper.pageComWalletList(dto);
    }

    @Override
    public List<Map<String, Object>> pageComWalletReconciliationList(SearchParamDTO dto) {
        return this.comWalletMapper.pageComWalletReconciliationList(dto);
    }

    @Override
    public List<Map<String, Object>> pageComWalletAccountDetailList(SearchParamDTO dto) {
        return this.comWalletMapper.pageComWalletAccountDetailList(dto);
    }

    @Override
    public Result getComWalletAccountByComId(SearchParamDTO dto) throws V5BusinessException {
        Result r2;
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570comId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Object> rec = this.comWalletMapper.getComWalletAccountByComId(dto.getComId());
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("comId", this.comWalletMapper.getMerchantNoByComId(dto.getComId()));
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", JwtUtil.createJWT(p));
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        Result r1 = (Result)JSON.parseObject((String)HttpUtil.post((String)(platUrl + "/pay/gongshang/account/query"), requestMap), Result.class);
        System.out.println(JSON.toJSONString((Object)r1));
        if ("0".equals(r1.getRetType())) {
            Map map = (Map)r1.getData();
            rec.put("accountStatus", PaymentServiceConst.getAccountStatus(map.get("account_state").toString()));
            requestMap = new HashMap();
            p.put("walletAccountNo", rec.get("walletAccountNo"));
            requestMap.put("token", JwtUtil.createJWT(p));
            r2 = (Result)JSON.parseObject((String)HttpUtil.post((String)(platUrl + "/pay/gongshang/account/balance/query"), requestMap), Result.class);
            System.out.println(JSON.toJSONString((Object)r2));
            if (!"0".equals(r2.getRetType())) {
                throw new V5BusinessException("-1", r2.getMsg());
            }
        } else {
            throw new V5BusinessException("-1", r1.getMsg());
        }
        Map map2 = (Map)r2.getData();
        rec.put("totalAmount", map2.get("ledger_bal"));
        rec.put("availableAmount", map2.get("available_bal"));
        rec.put("frozenAmount", map2.get("funds_held"));
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", rec);
    }

    @Override
    public void taskComWalletAccountByAllComId() throws V5BusinessException {
        List<Map<String, Object>> recList = this.comWalletMapper.findComWalletAccountByAllComId();
        for (Map<String, Object> rec : recList) {
            HashMap<Object, Object> p = new HashMap<Object, Object>();
            p.put("comId", this.comWalletMapper.getMerchantNoByComId(Long.parseLong(rec.get("comId") + "")));
            HashMap<String, String> requestMap = new HashMap<String, String>();
            requestMap.put("token", JwtUtil.createJWT(p));
            String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
            Result r1 = (Result)JSON.parseObject((String)HttpUtil.post((String)(platUrl + "/pay/gongshang/account/query"), requestMap), Result.class);
            if ("0".equals(r1.getRetType())) {
                Map map = (Map)r1.getData();
                rec.put("accountStatus", PaymentServiceConst.getAccountStatus(map.get("account_state").toString()));
                requestMap = new HashMap();
                p.put("walletAccountNo", rec.get("walletAccountNo"));
                requestMap.put("token", JwtUtil.createJWT(p));
                Result r2 = (Result)JSON.parseObject((String)HttpUtil.post((String)(platUrl + "/pay/gongshang/account/balance/query"), requestMap), Result.class);
                if ("0".equals(r2.getRetType())) {
                    Map map2 = (Map)r2.getData();
                    this.comWalletMapper.saveOrUpdateDualAccount(Long.parseLong(rec.get("comId") + ""), rec.get("comName") + "", rec.get("walletAccountNo") + "", map2.get("ledger_bal") + "", map2.get("available_bal") + "", map2.get("funds_held") + "");
                }
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Result updateComWalletAccount(ComWalletAccount comWalletAccount) throws V5BusinessException {
        if (comWalletAccount.getComId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570comId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)comWalletAccount.getMobilePhone())) {
            throw new V5BusinessException("-1", "\u53c2\u6570\u7ed1\u5b9a\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int count = this.comWalletMapper.updateComWalletAccount(comWalletAccount);
        if (count == 0) {
            return Result.fail((String)"\u64cd\u4f5c\u5931\u8d25:");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public List<Map<String, Object>> getComWalletAccountTradeDetail(SearchParamDTO dto, Integer page, Integer rows) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getWalletAccountNo())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u94b1\u5305\u8d26\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (page == null) {
            throw new V5BusinessException("-1", "\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rows == null) {
            throw new V5BusinessException("-1", "\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getStartTime())) {
            throw new V5BusinessException("-1", "\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)dto.getEndTime())) {
            throw new V5BusinessException("-1", "\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("id", this.comWalletMapper.getMerchantNoByComId(dto.getComId()));
        p.put("pageNumber", page.toString());
        p.put("pageSize", rows.toString());
        p.put("walletAccountNo", dto.getWalletAccountNo());
        p.put("startDate", dto.getStartTime());
        p.put("endDate", dto.getEndTime());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/record/query"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            Map map = (Map)result.getData();
            if (Integer.parseInt(map.get("total_size").toString()) == 0) {
                return new ArrayList<Map<String, Object>>();
            }
            ArrayList recordlist = (ArrayList)JSON.parseObject((String)map.get("balance_records").toString(), (TypeReference)new TypeReference<ArrayList<Map>>(){}, (Feature[])new Feature[0]);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            if (recordlist.size() > 0) {
                for (Map record : recordlist) {
                    String comName;
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("trade_date", record.get("trade_date").toString().substring(0, record.get("trade_date").toString().length() - 2));
                    m.put("trade_flow_no", record.get("trade_flow_no"));
                    m.put("flow_no", record.get("flow_no"));
                    m.put("accounts_deal_type", PaymentServiceConst.getAccountDealType(record.get("accounts_deal_type").toString()));
                    m.put("accounts_deal_date", record.get("accounts_deal_date").toString().substring(0, record.get("accounts_deal_date").toString().length() - 2));
                    m.put("amount", record.get("amount"));
                    m.put("balance", record.get("balance"));
                    m.put("direction", PaymentServiceConst.getDirection(record.get("direction").toString()));
                    m.put("hand_status", PaymentServiceConst.getHandStatus(record.get("hand_status").toString()));
                    m.put("create_date", record.get("create_date").toString().substring(0, record.get("create_date").toString().length() - 2));
                    m.put("serviceType", PaymentServiceConst.getServiceType(record.get("service_code").toString()));
                    m.put("trade_type", PaymentServiceConst.getTradeType(record.get("trade_type").toString()));
                    m.put("account_in", StringUtils.isEmpty((CharSequence)record.get("account_in").toString()) ? "-" : record.get("account_in"));
                    m.put("account_out", StringUtils.isEmpty((CharSequence)record.get("account_out").toString()) ? "-" : record.get("account_out"));
                    m.put("wallet_account_no", dto.getWalletAccountNo());
                    m.put("comId", dto.getComId());
                    if (StringUtils.isEmpty((CharSequence)record.get("account_in").toString())) {
                        m.put("account_in_name", "-");
                    } else {
                        comName = this.comWalletMapper.getComNameByWalletNo(record.get("account_in").toString());
                        m.put("account_in_name", StringUtils.isEmpty((CharSequence)comName) ? "-" : comName);
                    }
                    if (StringUtils.isEmpty((CharSequence)record.get("account_out").toString())) {
                        m.put("account_out_name", "-");
                    } else {
                        comName = this.comWalletMapper.getComNameByWalletNo(record.get("account_out").toString());
                        m.put("account_out_name", StringUtils.isEmpty((CharSequence)comName) ? "-" : comName);
                    }
                    m.put("memo", StringUtils.isEmpty((CharSequence)record.get("memo").toString()) ? "-" : record.get("memo"));
                    list.add(m);
                }
            }
            return list;
        }
        throw new V5BusinessException("-1", result.getMsg());
    }

    @Override
    public Result getComAccountTradeVoucher(SearchParamDTO dto) throws V5BusinessException {
        if (dto.getTradeFlowNo() == null) {
            throw new V5BusinessException("-1", "\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("comId", this.comWalletMapper.getMerchantNoByComId(dto.getComId()));
        p.put("bizOrderNo", dto.getTradeFlowNo());
        p.put("walletAccountNo", dto.getWalletAccountNo());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        return (Result)JSON.parseObject((String)HttpUtil.post((String)(platUrl + "/pay/gongshang/account/trade/voucher"), requestMap), Result.class);
    }

    @Override
    public Result getComAccountPayVoucher(SearchParamDTO dto) throws V5BusinessException {
        if (dto.getTradeFlowNo() == null) {
            throw new V5BusinessException("-1", "\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("bizOrderNo", dto.getTradeFlowNo());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/fbank/account/pay/voucher"), requestMap);
        return (Result)JSON.parseObject((String)resultStr, Result.class);
    }

    @Override
    public List<Map<String, Object>> pageAccountBaseRecord(SearchParamDTO dto) throws V5BusinessException {
        return this.comWalletMapper.pageAccountBaseRecordList(dto);
    }

    @Override
    public Result getAllBankCodeData() {
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", this.comWalletMapper.getAllBankCodeData());
    }

    @Override
    public List<Map<String, Object>> pageComWalletApproveList(SearchParamDTO dto) {
        return this.comWalletMapper.pageComWalletApproveList(dto);
    }

    @Override
    public Result getComWalletApproveById(SearchParamDTO dto) throws V5BusinessException {
        if (dto.getId() == null) {
            throw new V5BusinessException("-1", "\u5ba1\u6279Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Object> rec = this.comWalletMapper.getComWalletApproveById(dto.getId());
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", rec);
    }

    @Override
    public List<Map<String, Object>> pageComWalletChangeList(SearchParamDTO dto) {
        return this.comWalletMapper.getComWalletChangeDetailById(Long.parseLong(dto.getQ()));
    }

    @Override
    public Result updateComWalletApproveStatus(ComWalletChangeEvent comWalletChangeEvent) throws V5BusinessException {
        if (comWalletChangeEvent.getComWalletChangeEventId() == null) {
            throw new V5BusinessException("-1", "\u5ba1\u6279Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (comWalletChangeEvent.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)comWalletChangeEvent.getApproveStatus())) {
            throw new V5BusinessException("-1", "\u5ba1\u6279\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Object> accountMap = this.comWalletMapper.getComWalletAccountByComId(comWalletChangeEvent.getComId());
        if (accountMap == null) {
            throw new V5BusinessException("-1", "\u672a\u627e\u5230\u94b1\u5305\u4fe1\u606f");
        }
        if ("1".equals(comWalletChangeEvent.getApproveStatus())) {
            HashMap p = Maps.newHashMap();
            p.put("oldBankCardNoUrl", comWalletChangeEvent.getBankCardUrl());
            p.put("comId", this.comWalletMapper.getMerchantNoByComId(comWalletChangeEvent.getComId()));
            p.put("comName", String.valueOf(accountMap.get("comName")));
            p.put("mobilePhone", String.valueOf(accountMap.get("mobilePhone")));
            String bCard = this.comWalletMapper.getInfoByFieldAndId("bankCardNo", comWalletChangeEvent.getComWalletChangeEventId());
            p.put("newBankCardNo", StringUtils.isNotEmpty((CharSequence)bCard) ? bCard : String.valueOf(accountMap.get("bankCardNo")));
            String bCode = this.comWalletMapper.getInfoByFieldAndId("bankCode", comWalletChangeEvent.getComWalletChangeEventId());
            p.put("newBankCode", StringUtils.isNotEmpty((CharSequence)bCode) ? bCode : String.valueOf(accountMap.get("bankCode")));
            p.put("oldBankCardNo", String.valueOf(accountMap.get("bankCardNo")));
            String token = JwtUtil.createJWT(p);
            HashMap requestMap = Maps.newHashMap();
            requestMap.put("token", token);
            String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
            Result result = (Result)JSON.parseObject((String)HttpUtil.post((String)(platUrl + "/pay/fbank/com/union/bind"), (Map)requestMap), Result.class);
            if ("-1".equals(result.getRetType())) {
                return result;
            }
            List<Map<String, Object>> list = this.comWalletMapper.getComWalletChangeDetailById(comWalletChangeEvent.getComWalletChangeEventId());
            if (list.size() > 0) {
                String tj = "";
                for (Map<String, Object> map : list) {
                    tj = tj + map.get("changeCode") + " = '" + map.get("changeAfterInfo") + "' , ";
                }
                String sqlStr = "UPDATE com_wallet_account SET " + tj + " updateTime = '" + DateUtils.getDate("yyyy-MM-dd HH:mm:ss") + "' , updateBy = '" + comWalletChangeEvent.getApprovePerId() + "' WHERE comId = " + comWalletChangeEvent.getComId();
                this.comWalletMapper.changeAccountBySql(sqlStr);
            }
        }
        comWalletChangeEvent.setApproveTime(new Date());
        this.comWalletMapper.updateComWalletApproveStatus(comWalletChangeEvent);
        if ("2".equals(comWalletChangeEvent.getApproveStatus())) {
            Map<String, Object> rec = this.comWalletMapper.getComWalletApproveById(comWalletChangeEvent.getComWalletChangeEventId());
            Map<String, Object> fMap = this.comWalletMapper.getComWalletChangeFieldsById(comWalletChangeEvent.getComWalletChangeEventId());
            if (rec != null && fMap != null) {
                String title = "\u4f01\u4e1a\u94b1\u5305\u4fe1\u606f\u4fee\u6539\u5ba1\u6838\u4e0d\u901a\u8fc7";
                String string = "\u4fee\u6539\u7c7b\u578b\uff1a" + rec.get("typeName") + "\\n\u539f\u4fe1\u606f\uff1a" + fMap.get("oldChange") + "\\n\u65b0\u4fe1\u606f\uff1a" + fMap.get("newChange") + "\\n\u5ba1\u6279\u7ed3\u679c\uff1a" + rec.get("statusName") + "\\n\u5ba1\u6279\u5907\u6ce8\uff1a" + rec.get("approveContent") + "\u3002";
            }
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public void accountBaseRecordJob() throws Exception {
        Map<String, String> mapConditions;
        String conditions = this.commonService.getConditions("TDH-001");
        if (StringUtils.isNotEmpty((CharSequence)conditions)) {
            mapConditions = (Map)JSON.parseObject((String)conditions, Map.class);
        } else {
            mapConditions = Maps.newHashMap();
            mapConditions.put("pageNumber", "1");
            mapConditions.put("pageSize", "500");
            mapConditions.put("startDate", "2019-08-01");
            mapConditions.put("endDate", "2019-08-03");
        }
        this.logger.debug("    ================ \u6258\u5e95\u6237\u53c2\u6570\uff1a" + mapConditions.toString());
        if (DateUtils.dateCompare((String)mapConditions.get("startDate"), DateUtils.getDate()) && DateUtils.dateCompare(DateUtils.getDate(), (String)mapConditions.get("endDate"))) {
            this.logger.debug("    ================ \u6258\u5e95\u6237\u8fbe\u5230\u5f53\u524d\u5929\u8303\u56f4...");
            return;
        }
        HashMap<String, String> p = Maps.newHashMap();
        p.put("pageNumber", (String)mapConditions.get("pageNumber"));
        p.put("pageSize", (String)mapConditions.get("pageSize"));
        p.put("startDate", (String)mapConditions.get("startDate"));
        p.put("endDate", (String)mapConditions.get("endDate"));
        String token = JwtUtil.createJWT((Map<Object, Object>)p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        Result result = (Result)JSON.parseObject((String)HttpUtil.post((String)(platUrl + "/pay/fbank/account/base/record/query"), requestMap), Result.class);
        if ("0".equals(result.getRetType())) {
            Map map = (Map)result.getData();
            System.out.println(map);
            if (Integer.parseInt(map.get("total_rows").toString()) == 0) {
                p = new HashMap();
                p.put("pageNumber", "1");
                p.put("pageSize", "500");
                p.put("startDate", DateUtils.dateAdd("", (String)mapConditions.get("endDate"), "yyyy-MM-dd", 1));
                p.put("endDate", DateUtils.dateAdd("", (String)mapConditions.get("endDate"), "yyyy-MM-dd", 1));
                this.commonService.setConditions("TDH-001", JSONObject.toJSONString(p));
                this.logger.debug("    ================ \u6258\u5e95\u6237\u65f6\u95f4\u533a\u95f4\u67e5\u65e0\u6570\u636e\uff0c\u53c2\u6570\u91cd\u7f6e\u3001\u7f13\u5b58...");
                return;
            }
            if (Integer.parseInt(map.get("total_rows").toString()) < 500) {
                p = new HashMap();
                p.put("pageNumber", "1");
                p.put("pageSize", "500");
                p.put("startDate", DateUtils.dateAdd("", (String)mapConditions.get("endDate"), "yyyy-MM-dd", 1));
                p.put("endDate", DateUtils.dateAdd("", (String)mapConditions.get("endDate"), "yyyy-MM-dd", 1));
                this.logger.debug("    ================ \u6258\u5e95\u6237\u65f6\u95f4\u533a\u95f4\u67e5\u8be2\u6570\u636e\u4e0d\u8db3500\u6761\uff0c\u53c2\u6570\u5206\u9875\u91cd\u7f6e\u3001\u65e5\u671f\u53d8\u66f4...");
            } else {
                p = new HashMap();
                p.put("pageNumber", String.valueOf(Integer.parseInt((String)mapConditions.get("pageNumber")) + 1));
                p.put("pageSize", "500");
                p.put("startDate", (String)mapConditions.get("startDate"));
                p.put("endDate", (String)mapConditions.get("endDate"));
                this.logger.debug("    ================ \u6258\u5e95\u6237\u65f6\u95f4\u533a\u95f4\u67e5\u8be2\u6570\u636e\u6ee1\u8db3500\u6761\uff0c\u53c2\u6570\u65e5\u671f\u4e0d\u53d8\u3001\u5206\u9875\u53d8\u66f4...");
            }
            ArrayList recordlist = (ArrayList)JSON.parseObject((String)map.get("tran_hist_detail").toString(), (TypeReference)new TypeReference<ArrayList<Map>>(){}, (Feature[])new Feature[0]);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            if (recordlist.size() > 0) {
                for (Map record : recordlist) {
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put("balType", PaymentServiceConst.getBalType(record.get("bal_type").toString()));
                    m.put("reversalTranType", (String)record.get("reversal_tran_type"));
                    m.put("tranDesc", (String)record.get("tran_desc"));
                    m.put("statusInfo", (String)record.get("status_info"));
                    m.put("tfrAcctType", (String)record.get("tfr_acct_type"));
                    m.put("tranTime", (String)record.get("tran_time"));
                    m.put("reference", (String)record.get("reference"));
                    m.put("tfrAcctName", (String)record.get("tfr_acct_name"));
                    m.put("ccy", (String)record.get("ccy"));
                    m.put("previousBalAmt", (String)record.get("previous_bal_amt"));
                    m.put("othBankCode", (String)record.get("oth_bank_code"));
                    m.put("tradeSerialNo", (String)record.get("seq_no"));
                    m.put("effectDate", (String)record.get("effect_date"));
                    m.put("tranDate", (String)record.get("tran_date"));
                    m.put("tranCode", (String)record.get("tran_code"));
                    m.put("tranType", (String)record.get("tran_type"));
                    m.put("actualBalAmt", (String)record.get("actual_bal_amt"));
                    m.put("ledgerBal", (String)record.get("ledger_bal"));
                    m.put("reverse", PaymentServiceConst.getReverse(record.get("reverse").toString()));
                    m.put("tfrAcctNo", (String)record.get("tfr_acct_no"));
                    m.put("crDrPrevious", PaymentServiceConst.getCrDr(record.get("cr_dr_previous").toString()));
                    m.put("postDate", (String)record.get("post_date"));
                    m.put("crDrMaintInd", PaymentServiceConst.getCrDr(record.get("cr_dr_maint_ind").toString()));
                    m.put("tradeAmount", (String)record.get("tran_amt"));
                    m.put("othBankName", (String)record.get("oth_bank_name"));
                    m.put("status", (String)record.get("status"));
                    list.add(m);
                }
            }
            if (list.size() > 0) {
                this.comWalletMapper.batchInsertAccountBaseRecord(list);
            }
            this.commonService.setConditions("TDH-001", JSONObject.toJSONString(p));
        } else {
            this.logger.error(result.getMsg());
            if ("\u67e5\u8be2\u65e0\u8fd4\u56de\u8bb0\u5f55".equals(result.getMsg())) {
                p = new HashMap<String, String>();
                p.put("pageNumber", "1");
                p.put("pageSize", "500");
                p.put("startDate", DateUtils.dateAdd("", (String)mapConditions.get("endDate"), "yyyy-MM-dd", 1));
                p.put("endDate", DateUtils.dateAdd("", (String)mapConditions.get("endDate"), "yyyy-MM-dd", 1));
                this.commonService.setConditions("TDH-001", JSONObject.toJSONString(p));
                this.logger.debug("    ================ \u6258\u5e95\u6237\u65f6\u95f4\u533a\u95f4\u67e5\u65e0\u6570\u636e\uff0c\u53c2\u6570\u91cd\u7f6e\u3001\u7f13\u5b58...");
            }
        }
    }

    @Override
    public Result exprokComWalletReconciliation(SearchParamDTO dto, HttpServletResponse response) throws V5BusinessException {
        if (StringUtils.isEmpty((CharSequence)dto.getFundFlowType())) {
            return Result.fail((String)"\u8d44\u91d1\u6d41\u5411\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OutputStream os = null;
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            HSSFCell cell;
            int i;
            String fileName = "\u5bf9\u8d26\u6570\u636e" + DateUtils.getDate("yyyyMMddHHmmss") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String(fileName.getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            HSSFSheet sheet1 = wb.createSheet("\u5bf9\u8d26\u6570\u636e");
            List<Map<String, Object>> list = this.comWalletMapper.pageComWalletReconciliationList(dto);
            CellStyle stringStyle = ExcelUtil.getStringStyle(wb);
            HSSFFont titleFont = wb.createFont();
            HSSFCellStyle titleStyle = wb.createCellStyle();
            titleFont.setFontHeightInPoints((short)11);
            titleFont.setColor(HSSFColor.BLUE.index);
            titleFont.setFontName("\u9ed1\u4f53");
            titleStyle.setAlignment((short)2);
            titleStyle.setVerticalAlignment((short)1);
            titleStyle.setFont(titleFont);
            titleStyle.setWrapText(true);
            HSSFDataFormat format = wb.createDataFormat();
            titleStyle.setDataFormat(format.getFormat("@"));
            Map<String, Object> map = this.comWalletMapper.getWalletReconciliationSum(dto);
            String headerTitle = "";
            headerTitle = map == null ? MessageFormat.format("\u603b\u7b14\u6570\uff1a\u3010{0}\u3011\u7b14 | \u603b\u91d1\u989d\uff1a\u3010{1}\u3011\u5143 | \u6210\u529f\u7b14\u6570\uff1a\u3010{2}\u3011\u7b14 | \u6210\u529f\u91d1\u989d\uff1a\u3010{3}\u3011\u5143 | \u5931\u8d25\u7b14\u6570\uff1a\u3010{4}\u3011\u7b14 | \u5931\u8d25\u91d1\u989d\uff1a\u3010{5}\u3011\u5143 | \u5904\u7406\u4e2d\u7b14\u6570\uff1a\u3010{6}\u3011\u7b14 | \u5904\u7406\u4e2d\u91d1\u989d\uff1a\u3010{7}\u3011\u5143", 0, 0, 0, 0, 0, 0, 0, 0) : MessageFormat.format("\u603b\u7b14\u6570\uff1a\u3010{0}\u3011\u7b14 | \u603b\u91d1\u989d\uff1a\u3010{1}\u3011\u5143 | \u6210\u529f\u7b14\u6570\uff1a\u3010{2}\u3011\u7b14 | \u6210\u529f\u91d1\u989d\uff1a\u3010{3}\u3011\u5143 | \u5931\u8d25\u7b14\u6570\uff1a\u3010{4}\u3011\u7b14 | \u5931\u8d25\u91d1\u989d\uff1a\u3010{5}\u3011\u5143 | \u5904\u7406\u4e2d\u7b14\u6570\uff1a\u3010{6}\u3011\u7b14 | \u5904\u7406\u4e2d\u91d1\u989d\uff1a\u3010{7}\u3011\u5143", map.get("totalCount"), map.get("sumAmount"), map.get("successCount"), map.get("successAmount"), map.get("errorCount"), map.get("errorAmount"), map.get("processingCount"), map.get("processingAmount"));
            HSSFCellStyle titleStyle1 = wb.createCellStyle();
            HSSFFont titleFont1 = wb.createFont();
            titleFont1.setFontHeightInPoints((short)11);
            titleFont1.setColor(HSSFColor.RED.index);
            titleFont1.setFontName("\u9ed1\u4f53");
            titleStyle1.setVerticalAlignment((short)1);
            titleStyle1.setFont(titleFont1);
            titleStyle1.setWrapText(true);
            HSSFRow rowFirst = sheet1.createRow(0);
            rowFirst.setHeight((short)1000);
            sheet1.addMergedRegion(new CellRangeAddress(0, 0, 0, 13));
            HSSFCell titleCell = rowFirst.createCell(0);
            titleCell.setCellValue(headerTitle);
            titleCell.setCellStyle(titleStyle1);
            HSSFRow secondFirst = sheet1.createRow(1);
            String[] secondArr = new String[]{"\u5e8f\u53f7", "\u4ea4\u6613\u6d41\u6c34\u53f7", "\u94f6\u884c\u4ea4\u6613\u7c7b\u578b", "\u4ea4\u6613\u72b6\u6001", "\u4ea4\u6613\u8ba2\u5355\u521b\u5efa\u65f6\u95f4", "\u4ea4\u6613\u91d1\u989d", "\u51fa\u8d26\u65b9\u6237\u540d", "\u51fa\u8d26\u65b9\u8d26\u53f7", "\u51fa\u8d26\u65b9\u94f6\u884c", "\u5165\u8d26\u65b9\u6237\u540d", "\u5165\u8d26\u65b9\u8d26\u53f7", "\u5165\u8d26\u65b9\u94f6\u884c", "\u5165\u8d26\u65b9\u8bc1\u4ef6\u53f7", "\u5907\u6ce8"};
            for (i = 0; i < secondArr.length; ++i) {
                cell = secondFirst.createCell(i);
                int column = i == 0 ? 1500 : (i == 4 ? 5000 : (i == 1 || i == 7 || i == 10 || i == 13 ? 8000 : (i == 6 || i == 9 ? 10000 : (i == 13 ? 14000 : 4000))));
                sheet1.setColumnWidth(i, column);
                sheet1.setDefaultColumnStyle(i, stringStyle);
                cell.setCellStyle(titleStyle);
            }
            for (i = 0; i < secondArr.length; ++i) {
                cell = secondFirst.createCell(i);
                cell.setCellValue(secondArr[i]);
                cell.setCellStyle(titleStyle);
            }
            CellStyle greenStyle = ExcelUtil.getColorStyle(wb, IndexedColors.SEA_GREEN.index);
            CellStyle redStyle = ExcelUtil.getColorStyle(wb, IndexedColors.RED.index);
            CellStyle blueStyle = ExcelUtil.getColorStyle(wb, IndexedColors.BLUE.index);
            HSSFRow row = null;
            int rowIndex = 2;
            for (Map<String, Object> result : list) {
                row = sheet1.createRow(rowIndex);
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue((double)(rowIndex - 1));
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(result.get("tradeSerialNo") != null ? result.get("tradeSerialNo").toString() : null);
                HSSFCell cell2 = row.createCell(2);
                cell2.setCellValue(result.get("bankTradeType") != null ? result.get("bankTradeType").toString() : null);
                HSSFCell cell3 = row.createCell(3);
                cell3.setCellValue(result.get("tradeStatus") != null ? result.get("tradeStatus").toString() : null);
                if (ObjectUtil.equal((Object)result.get("tradeStatus"), (Object)"\u4ea4\u6613\u6210\u529f")) {
                    cell3.setCellStyle(greenStyle);
                } else if (ObjectUtil.equal((Object)result.get("tradeStatus"), (Object)"\u4ea4\u6613\u5931\u8d25")) {
                    cell3.setCellStyle(redStyle);
                } else {
                    cell3.setCellStyle(blueStyle);
                }
                HSSFCell cell4 = row.createCell(4);
                cell4.setCellValue(result.get("tradeStartTime") != null ? result.get("tradeStartTime").toString() : null);
                HSSFCell cell5 = row.createCell(5);
                cell5.setCellValue(result.get("tradeAmount") != null ? result.get("tradeAmount").toString() : null);
                cell5.setCellStyle(redStyle);
                HSSFCell cell6 = row.createCell(6);
                cell6.setCellValue(result.get("expendAccountName") != null ? result.get("expendAccountName").toString() : null);
                HSSFCell cell7 = row.createCell(7);
                cell7.setCellValue(result.get("expendAccountNo") != null ? result.get("expendAccountNo").toString() : null);
                HSSFCell cell8 = row.createCell(8);
                cell8.setCellValue(result.get("expendBank") != null ? result.get("expendBank").toString() : null);
                HSSFCell cell9 = row.createCell(9);
                cell9.setCellValue(result.get("incomeAccountName") != null ? result.get("incomeAccountName").toString() : null);
                HSSFCell cell10 = row.createCell(10);
                cell10.setCellValue(result.get("incomeAccountNo") != null ? result.get("incomeAccountNo").toString() : null);
                HSSFCell cell11 = row.createCell(11);
                cell11.setCellValue(result.get("incomeBank") != null ? result.get("incomeBank").toString() : null);
                HSSFCell cell12 = row.createCell(12);
                cell12.setCellValue(result.get("incomeCerNo") != null ? result.get("incomeCerNo").toString() : null);
                HSSFCell cell13 = row.createCell(13);
                cell13.setCellValue(result.get("remark") != null ? result.get("remark").toString() : null);
                ++rowIndex;
            }
            wb.write(os);
            os.close();
            wb.close();
        }
        catch (Exception e) {
            throw new V5BusinessException("-1", e.getMessage());
        }
        finally {
            try {
                os.close();
                wb.close();
            }
            catch (IOException iOException) {}
        }
        return Result.success((String)"\u5bfc\u51fa\u5bf9\u8d26\u6587\u4ef6\u5931\u8d25");
    }

    public static void main(String[] args) {
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("id", "591286668472877057");
        p.put("pageNumber", "1");
        p.put("pageSize", "100");
        p.put("walletAccountNo", "3008001013547579000010");
        p.put("startDate", "2021-12-29");
        p.put("endDate", "2022-01-08");
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = "http://pay.bcxin.com.cn:81/";
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/record/query"), requestMap);
        System.out.println(resultStr);
    }
}

