/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.wechat.WechatReply;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.WechatReplyRequest;
import com.zbkj.common.request.WechatReplySearchRequest;
import com.zbkj.service.dao.WechatReplyDao;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.WechatReplyService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatReplyServiceImpl
extends ServiceImpl<WechatReplyDao, WechatReply>
implements WechatReplyService {
    @Resource
    private WechatReplyDao dao;
    @Autowired
    private SystemAttachmentService systemAttachmentService;

    @Override
    public List<WechatReply> getList(WechatReplySearchRequest request, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)request.getType())) {
            lqw.eq(WechatReply::getType, (Object)request.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getKeywords())) {
            lqw.eq(WechatReply::getKeywords, (Object)URLUtil.decode((String)request.getKeywords()));
        }
        lqw.orderByDesc(WechatReply::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean create(WechatReplyRequest wechatReplyRequest) {
        WechatReply voByKeywords = this.getVoByKeywords(wechatReplyRequest.getKeywords());
        if (ObjectUtil.isNotNull((Object)voByKeywords)) {
            throw new CrmebException(wechatReplyRequest.getKeywords() + "\u5173\u952e\u5b57\u5df2\u7ecf\u5b58\u5728");
        }
        WechatReply wechatReply = new WechatReply();
        BeanUtils.copyProperties((Object)wechatReplyRequest, (Object)wechatReply);
        wechatReply.setData(this.systemAttachmentService.clearPrefix(wechatReply.getData()));
        return this.save(wechatReply);
    }

    private Boolean updateVo(WechatReply wechatReply) {
        WechatReply voByKeywords = this.getVoByKeywords(wechatReply.getKeywords());
        if (ObjectUtil.isNotNull((Object)voByKeywords) && !wechatReply.getId().equals(voByKeywords.getId())) {
            throw new CrmebException(wechatReply.getKeywords() + "\u5173\u952e\u5b57\u5df2\u7ecf\u5b58\u5728");
        }
        wechatReply.setData(this.systemAttachmentService.clearPrefix(wechatReply.getData()));
        return this.updateById(wechatReply);
    }

    @Override
    public WechatReply getVoByKeywords(String keywords) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(WechatReply::getKeywords, (Object)keywords);
        lqw.last(" limit 1");
        return (WechatReply)this.dao.selectOne((Wrapper)lqw);
    }

    private WechatReply getInfoException(Integer id) {
        WechatReply info = this.getInfo(id);
        if (null == info) {
            throw new CrmebException("\u6ca1\u6709\u627e\u5230\u76f8\u5173\u6570\u636e");
        }
        return info;
    }

    @Override
    public WechatReply getInfo(Integer id) {
        return (WechatReply)this.getById(id);
    }

    @Override
    public Boolean updateReply(WechatReplyRequest wechatReplyRequest) {
        WechatReply wechatReply = this.getInfoException(wechatReplyRequest.getId());
        BeanUtils.copyProperties((Object)wechatReplyRequest, (Object)wechatReply);
        return this.updateVo(wechatReply);
    }

    @Override
    public Boolean updateStatus(Integer id) {
        WechatReply wechatReply;
        wechatReply.setStatus(Boolean.valueOf((wechatReply = this.getInfoException(id)).getStatus() == false));
        return this.updateVo(wechatReply);
    }

    @Override
    public WechatReply keywordsInfo(String keywords) {
        if (StrUtil.isBlank((CharSequence)keywords)) {
            return null;
        }
        keywords = URLUtil.decode((String)keywords);
        return this.getVoByKeywords(keywords);
    }
}

