/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.record.ProductDayRecord;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.ProductRankingRequest;
import com.zbkj.service.dao.ProductDayRecordDao;
import com.zbkj.service.service.ProductDayRecordService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ProductDayRecordServiceImpl
extends ServiceImpl<ProductDayRecordDao, ProductDayRecord>
implements ProductDayRecordService {
    @Resource
    private ProductDayRecordDao dao;

    @Override
    public PageInfo<ProductDayRecord> getRanking(ProductRankingRequest request) {
        String endDate;
        String startDate;
        DateTime date = DateUtil.date();
        switch (request.getDateLimit()) {
            case "yesterday": {
                startDate = DateUtil.yesterday().toString("yyyy-MM-dd");
                endDate = DateUtil.yesterday().toString("yyyy-MM-dd");
                break;
            }
            case "lately7": {
                startDate = DateUtil.offsetDay((Date)date, (int)-7).toString("yyyy-MM-dd");
                endDate = DateUtil.yesterday().toString("yyyy-MM-dd");
                break;
            }
            case "lately30": {
                startDate = DateUtil.offsetDay((Date)date, (int)-30).toString("yyyy-MM-dd");
                endDate = DateUtil.yesterday().toString("yyyy-MM-dd");
                break;
            }
            case "week": {
                startDate = DateUtil.beginOfWeek((Date)date).toString("yyyy-MM-dd");
                endDate = DateUtil.endOfWeek((Date)date).toString("yyyy-MM-dd");
                break;
            }
            case "month": {
                startDate = DateUtil.beginOfMonth((Date)date).toString("yyyy-MM-dd");
                endDate = DateUtil.endOfMonth((Date)date).toString("yyyy-MM-dd");
                break;
            }
            case "year": {
                startDate = DateUtil.beginOfYear((Date)date).toString("yyyy-MM-dd");
                endDate = DateUtil.endOfYear((Date)date).toString("yyyy-MM-dd");
                break;
            }
            default: {
                Object split = request.getDateLimit().split(",");
                if (((String[])split).length < 2) {
                    throw new CrmebException("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u65f6\u95f4\u8303\u56f4");
                }
                startDate = DateUtil.parse((String)split[0]).toString("yyyy-MM-dd");
                endDate = DateUtil.parse((String)split[1]).toString("yyyy-MM-dd");
            }
        }
        Page startPage = PageHelper.startPage((int)request.getPage(), (int)request.getLimit());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"product_id", "sum(page_view) as page_view", "sum(collect_num) as collect_num", "sum(add_cart_num) as add_cart_num", "sum(order_product_num) as order_product_num", "sum(order_success_product_fee) as order_success_product_fee"});
        wrapper.between((Object)"date", (Object)startDate, (Object)endDate);
        wrapper.eq((Object)"mer_id", (Object)request.getMerId());
        wrapper.groupBy((Object)"product_id");
        switch (request.getSortKey()) {
            case "pageviews": {
                wrapper.orderByDesc((Object)"page_view");
                break;
            }
            case "collectNum": {
                wrapper.orderByDesc((Object)"collect_num");
                break;
            }
            case "addCartNum": {
                wrapper.orderByDesc((Object)"add_cart_num");
                break;
            }
            case "salesNum": {
                wrapper.orderByDesc((Object)"order_product_num");
                break;
            }
            case "salesAmount": {
                wrapper.orderByDesc((Object)"order_success_product_fee");
            }
        }
        List recordList = this.dao.selectList((Wrapper)wrapper);
        return CommonPage.copyPageInfo((Page)startPage, (List)recordList);
    }
}

