/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.express.Express;
import com.zbkj.common.model.wechat.video.PayComponentDeliveryCompany;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.vo.wxvedioshop.delivery.DeliveryCompanyVo;
import com.zbkj.service.dao.PayComponentDeliveryCompanyDao;
import com.zbkj.service.service.ExpressService;
import com.zbkj.service.service.PayComponentDeliveryCompanyService;
import com.zbkj.service.service.WechatVideoDeliveryService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayComponentDeliveryCompanyServiceImpl
extends ServiceImpl<PayComponentDeliveryCompanyDao, PayComponentDeliveryCompany>
implements PayComponentDeliveryCompanyService {
    @Resource
    private PayComponentDeliveryCompanyDao dao;
    @Autowired
    private WechatVideoDeliveryService wechatVideoDeliveryService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ExpressService expressService;
    private final String DELIVERY_COMPANY_LIST = "delivery_company_list";

    @Override
    public void updateData() {
        List<DeliveryCompanyVo> companyVoList = this.wechatVideoDeliveryService.shopDeliveryGetCompanyList();
        List companyList = companyVoList.stream().map(e -> {
            PayComponentDeliveryCompany company = new PayComponentDeliveryCompany();
            company.setDeliveryId(e.getDeliveryId());
            company.setDeliveryName(e.getDeliveryName());
            return company;
        }).collect(Collectors.toList());
        boolean saveBatch = this.saveBatch(companyList, 100);
        if (!saveBatch) {
            throw new CrmebException("\u6279\u91cf\u66f4\u65b0\u7269\u6d41\u516c\u53f8\u9519\u8bef");
        }
        System.out.println("\u6279\u91cf\u66f4\u65b0\u7269\u6d41\u516c\u53f8\u6210\u529f");
    }

    @Override
    public List<PayComponentDeliveryCompany> getList() {
        if (!this.redisUtil.exists("delivery_company_list").booleanValue()) {
            LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
            lqw.select(new SFunction[]{PayComponentDeliveryCompany::getDeliveryId, PayComponentDeliveryCompany::getDeliveryName});
            lqw.eq(PayComponentDeliveryCompany::getIsDel, (Object)false);
            List deliveryCompanyList = this.dao.selectList((Wrapper)lqw);
            List<Express> expressList = this.expressService.findAll("normal");
            List<PayComponentDeliveryCompany> companyList = deliveryCompanyList.stream().filter(e -> {
                boolean exist = false;
                for (Express express : expressList) {
                    if (!express.getName().equals(e.getDeliveryName())) continue;
                    exist = true;
                    break;
                }
                return exist;
            }).collect(Collectors.toList());
            this.redisUtil.set("delivery_company_list", (Object)JSONArray.toJSONString(companyList), Long.valueOf(48L), TimeUnit.HOURS);
            return companyList;
        }
        String companyJsonStr = (String)this.redisUtil.get("delivery_company_list");
        List companyList = JSONArray.parseArray((String)companyJsonStr, PayComponentDeliveryCompany.class);
        return companyList;
    }

    @Override
    public PayComponentDeliveryCompany getByDeliveryId(String deliveryId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{PayComponentDeliveryCompany::getDeliveryId, PayComponentDeliveryCompany::getDeliveryName});
        lqw.eq(PayComponentDeliveryCompany::getIsDel, (Object)false);
        lqw.eq(PayComponentDeliveryCompany::getDeliveryId, (Object)deliveryId);
        return (PayComponentDeliveryCompany)this.dao.selectOne((Wrapper)lqw);
    }
}

