ALTER TABLE `eb_product`
    MODIFY COLUMN `biz_type` int(2) NULL DEFAULT 0 COMMENT '商品类型：0-实体 1-虚拟 2-特殊(考培) 3-保险 4-风评',
    ADD COLUMN `master_id` int(11) NULL COMMENT '主商品id，有该值的商品下单时需要关联主商品订单';

ALTER TABLE `eb_product_category`
    ADD COLUMN `pc_mall`      tinyint(1) NULL DEFAULT 1 COMMENT '1- pc商城可见 0-不可见',
    ADD COLUMN `wx_mini_risk` tinyint(1) NULL DEFAULT 0 COMMENT '1-微信小程序e站风评可见 0-不可见';

ALTER TABLE `eb_order`
    MODIFY COLUMN `type` int(2) NOT NULL DEFAULT 0 COMMENT '订单类型:0-普通订单，1-视频号订单，2-秒杀订单，50-e站风评订单';
ALTER TABLE `eb_order_detail`
    MODIFY COLUMN `source_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '源头业务编号,目前有考培的sourceId和风评的sourceId';

ALTER TABLE `eb_user`
    ADD COLUMN `org_name`    varchar(255) NULL COMMENT '组织域名称',
    ADD COLUMN `wx_union_id` varchar(255) NULL COMMENT '微信 union id';

CREATE TABLE `bcx_order_relation`
(
    `id`              int(11)      NOT NULL AUTO_INCREMENT COMMENT '订单关系id',
    `order_no`        varchar(255) NULL COMMENT '订单号：如果该值与主订单号一样，则该订单为主订单，否则为副订单',
    `master_order_no` varchar(255) NULL COMMENT '主订单号',
    PRIMARY KEY (`id`)
) COMMENT = '主订单关系表';

CREATE TABLE `bcx_user_org_auth`
(
    `id`           int(11)      NOT NULL AUTO_INCREMENT COMMENT '用户企业认证表id',
    `uid`          int(11)      NOT NULL COMMENT '用户id',
    `name`         varchar(255) NULL COMMENT '名称',
    `id_card_no`   varchar(255) NULL COMMENT '身份证号',
    `phone`        varchar(50)  NULL COMMENT '手机号',
    `auth_code`    varchar(20)  NULL COMMENT '验证码',
    `org_name`     varchar(255) NULL COMMENT '企业名称',
    `legal_person` varchar(255) NULL COMMENT '法人',
    `credit_code`  varchar(255) NULL COMMENT '统一社会信用代码',
    `reg_address`  varchar(255) NULL COMMENT '注册地',
    `address`      varchar(255) NULL COMMENT '详细地址',
    PRIMARY KEY (`id`)
) COMMENT = '用户企业认证表';

ALTER TABLE `eb_order`
    ADD COLUMN `url` varchar(255) NULL COMMENT '订单关联外部url';

-- INSERT INTO `eb_system_config` (`id`, `name`, `title`, `form_id`, `value`, `status`, `create_time`, `update_time`,
--                                 `form_name`)
-- VALUES (10000, 'e_risk_system_url', 'e_risk_system_url', 10000, 'http://estand.test.pss360.cn/', 0,
--         '2023-10-20 09:54:02', '2023-10-20 09:54:02', '');


ALTER TABLE `eb_order`
    ADD COLUMN `fapiao_status` int(2) NULL DEFAULT 0 COMMENT '0-未开 1-已开发票';

CREATE TABLE `bcx_fapiao_title`
(
    `id`           int(11) NOT NULL AUTO_INCREMENT COMMENT '发票抬头id',
    `uid`          int(11) NOT NULL COMMENT '用户id',
    `title_type`   int(2)       DEFAULT NULL COMMENT '0-个人 1-企业',
    `fapiao_type`  int(2)       DEFAULT NULL COMMENT '0-增值税普通 1-增值税专用',
    `title`        varchar(100) DEFAULT NULL COMMENT '发票抬头',
    `tax_no`       varchar(50)  DEFAULT NULL COMMENT '税号',
    `email`        varchar(50)  DEFAULT NULL COMMENT '邮箱',
    `bank_name`    varchar(100) DEFAULT NULL COMMENT '开户银行',
    `bank_account` varchar(50)  DEFAULT NULL COMMENT '银行账号',
    `address`      varchar(255) DEFAULT NULL COMMENT '企业地址',
    `phone`        varchar(20)  DEFAULT NULL COMMENT '企业电话',
    `is_default`   tinyint(1)   DEFAULT NULL COMMENT '0-否1- 默认抬头',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='发票抬头表';

CREATE TABLE `bcx_order_fapiao`
(
    `id`            int(11)       NOT NULL AUTO_INCREMENT COMMENT '订单发票id',
    `uid`           int(11)       NOT NULL COMMENT '用户id',
    `mer_id`        int(11)                DEFAULT NULL COMMENT '商户id',
    `order_no`      varchar(255)  NULL COMMENT '订单号',
    `title_type`    int(2)                 DEFAULT NULL COMMENT '0-个人 1-企业',
    `fapiao_type`   int(2)                 DEFAULT NULL COMMENT '0-增值税普通 1-增值税专用',
    `title`         varchar(100)           DEFAULT NULL COMMENT '发票抬头',
    `amount`        decimal(8, 2) NULL COMMENT '发票金额',
    `tax_no`        varchar(50)            DEFAULT NULL COMMENT '税号',
    `email`         varchar(50)            DEFAULT NULL COMMENT '邮箱',
    `bank_name`     varchar(100)           DEFAULT NULL COMMENT '开户银行',
    `bank_account`  varchar(50)            DEFAULT NULL COMMENT '银行账号',
    `address`       varchar(255)           DEFAULT NULL COMMENT '企业地址',
    `phone`         varchar(20)            DEFAULT NULL COMMENT '企业电话',
    `fapiao_status` int(2)        NULL     DEFAULT 0 COMMENT '0-未开 1-已开发票',
    `remark`        varchar(255)           DEFAULT NULL COMMENT '备注',
    `apply_no`      varchar(255)  NULL COMMENT '申请单号',
    `fapiao_no`     varchar(255)  NULL COMMENT '发票号码',
    `apply_time`    TIMESTAMP     NULL COMMENT '申请时间',
    `write_time`    TIMESTAMP     NULL COMMENT '开票时间',
    `create_time`   TIMESTAMP     NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time`   TIMESTAMP     NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='订单发票表';

-- ALTER TABLE `bcx_order_fapiao`
--     MODIFY COLUMN `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注';

ALTER TABLE `eb_merchant`
    ADD COLUMN `pc_mall`      tinyint(1) NULL DEFAULT 1 COMMENT '1- pc商城可见 0-不可见',
    ADD COLUMN `wx_mini_risk` tinyint(1) NULL DEFAULT 0 COMMENT '1-微信小程序e站风评可见 0-不可见';
-- -------已更新到dev test prev prod
