
ALTER TABLE `eb_order_detail`
    ADD COLUMN `source_id` varchar(255) NULL COMMENT '源头业务编号' AFTER `update_time`;

ALTER TABLE `eb_merchant_order`
    ADD COLUMN `last_delivery_time` timestamp NULL COMMENT '最新发货时间' AFTER `update_time`;

ALTER TABLE `eb_order`
    ADD COLUMN `biz_type` int(3) NULL COMMENT '业务类型:0-实物商品订单，1-虚拟商品订单,2-特殊类型(考培)订单' AFTER `region_code`;

ALTER TABLE eb_order
    MODIFY COLUMN `order_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '订单号',
    MODIFY COLUMN `plat_order_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '平台订单号';
ALTER TABLE eb_merchant_order
    MODIFY COLUMN `order_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '订单号';
ALTER TABLE `eb_order_detail`
    MODIFY COLUMN `order_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订单号';
ALTER TABLE `eb_refund_order`
    MODIFY COLUMN `refund_order_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '退款订单号',
    MODIFY COLUMN `order_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '商户订单号';
ALTER TABLE `eb_refund_order_info`
    MODIFY COLUMN `refund_order_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '退款订单号';
ALTER TABLE `eb_refund_order_status`
    MODIFY COLUMN `order_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '订单号';
ALTER TABLE `eb_order_status`
    MODIFY COLUMN `order_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '订单号';
ALTER TABLE `eb_order_profit_sharing`
    MODIFY COLUMN `order_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '订单号（商户）';
ALTER TABLE `eb_order_invoice`
    MODIFY COLUMN `order_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '订单号';
ALTER TABLE `eb_bill`
    MODIFY COLUMN `order_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '' COMMENT '关联订单';

CREATE TABLE `bcx_product_benefits` (
                                        `id` varchar(255) NOT NULL COMMENT '福利配置id',
                                        `sku_id` int(11) NOT NULL COMMENT '商品sku ID',
                                        `product_name` varchar(255) DEFAULT NULL COMMENT '商品名称',
                                        `company_id` varchar(255) NOT NULL COMMENT '企业id',
                                        `company_name` varchar(255) DEFAULT NULL COMMENT '企业名称',
                                        PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='福利配置表';

ALTER TABLE `eb_order`
    MODIFY COLUMN `total_num` int(11) NOT NULL DEFAULT 0 COMMENT '订单商品总数',
    MODIFY COLUMN `pro_total_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '商品总价',
    MODIFY COLUMN `total_postage` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '邮费',
    MODIFY COLUMN `total_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '订单总价',
    MODIFY COLUMN `coupon_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '优惠券金额',
    MODIFY COLUMN `integral_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '积分抵扣金额',
    MODIFY COLUMN `pay_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '实际支付金额',
    MODIFY COLUMN `pay_postage` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '支付邮费';
ALTER TABLE `eb_order_detail`
    MODIFY COLUMN `price` decimal(8, 2) NOT NULL COMMENT '商品单价',
    MODIFY COLUMN `vip_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '会员价格',
    MODIFY COLUMN `pay_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '实际支付金额',
    MODIFY COLUMN `pay_num` int(11) NOT NULL DEFAULT 0 COMMENT '购买数量',
    MODIFY COLUMN `freight_fee` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '运费金额',
    MODIFY COLUMN `coupon_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '优惠券金额',
    MODIFY COLUMN `integral_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '积分抵扣金额',
    MODIFY COLUMN `first_brokerage_fee` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '一级返佣金额',
    MODIFY COLUMN `second_brokerage_fee` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '二级返佣金额',
    MODIFY COLUMN `refund_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '退款金额',
    MODIFY COLUMN `refund_integral_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '退款积分抵扣金额',
    MODIFY COLUMN `refund_first_brokerage_fee` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '退一级返佣金额',
    MODIFY COLUMN `refund_second_brokerage_fee` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '退二级返佣金额';
ALTER TABLE `eb_merchant_order`
    MODIFY COLUMN `total_num` int(11) NOT NULL DEFAULT 0 COMMENT '订单商品总数',
    MODIFY COLUMN `pro_total_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '商品总价',
    MODIFY COLUMN `total_postage` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '邮费',
    MODIFY COLUMN `total_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '订单总价',
    MODIFY COLUMN `pay_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '实际支付金额',
    MODIFY COLUMN `pay_postage` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '支付邮费',
    MODIFY COLUMN `integral_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '积分抵扣金额',
    MODIFY COLUMN `coupon_price` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '优惠券金额';

ALTER TABLE `eb_product_attr_value`
    ADD COLUMN `plat_fee` decimal(8, 2) NULL COMMENT '平台抽佣';
ALTER TABLE `eb_order`
    ADD COLUMN `plat_fee` decimal(8, 2) NULL COMMENT '平台抽佣';
ALTER TABLE `eb_order_detail`
    ADD COLUMN `plat_fee` decimal(8, 2) NULL COMMENT '平台抽佣';
ALTER TABLE `eb_product`
    CHANGE COLUMN `type` `biz_type` int(2) NULL DEFAULT 0 COMMENT '商品类型：0-实体 1-虚拟 2-特殊(考培) 3-保险 等等';
