drop table `crmeb`.`bcx_channel`;
CREATE TABLE `crmeb`.`bcx_channel` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id(与eb_user表id保持一致)',
    `bcx_id` varchar(50) DEFAULT NULL COMMENT '平台id（org_开头）',
    `name` varchar(200) DEFAULT NULL COMMENT '渠道名称',
    `cooperation_start_time` datetime DEFAULT NULL COMMENT '合作开始时间，时分秒为：00:00:00',
    `cooperation_end_time` datetime DEFAULT NULL COMMENT '合作结束时间，时分秒为：23:59:59',
    `sign_people_id` bigint(20) DEFAULT NULL COMMENT '签单人id（bcx_department_member的id）',
    `serve_people_id` bigint(20) DEFAULT NULL COMMENT '客服人员id（bcx_department_member的id）',
    `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '状态：0无效，1有效',
    `create_time` datetime DEFAULT NULL COMMENT '创建时间',
    `update_time` datetime DEFAULT NULL COMMENT '更新时间',
    PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='渠道表';


ALTER TABLE `crmeb`.`bcx_product_benefits`
ADD COLUMN `is_enable_config` tinyint(4) NOT NULL DEFAULT 0 COMMENT '是否启用单独配置，0否，1是' AFTER `auth_end_time`,
ADD COLUMN `brokerage` decimal(8, 2) NOT NULL DEFAULT 0.00 COMMENT '分销员比例（一级返佣）' AFTER `is_enable_config`;


ALTER TABLE `crmeb`.`bcx_performance_report`
    ADD COLUMN `brokerage_price_total` decimal(15, 2) NULL DEFAULT NULL COMMENT '佣金金额，（分销商时，一级、二级总的佣金金额）' AFTER `brokerage_calculate_ratio`;


ALTER TABLE `crmeb`.`bcx_settle`
    ADD COLUMN `fxs_settle_id` bigint(20) NULL DEFAULT NULL COMMENT '分销商的结算单id，用来关联结算的' AFTER `belong_type`;

ALTER TABLE `crmeb`.`bcx_settle_bill`
    ADD COLUMN `fxs_settle_bill_id` bigint(20) NULL DEFAULT NULL COMMENT '分销商的账单id，用来关联结算的' AFTER `belong_type`;
