DROP TABLE IF EXISTS bcx_fapiao_source;
CREATE TABLE `bcx_fapiao_source`
(
    `id`           int(11)      NOT NULL AUTO_INCREMENT COMMENT '源单id',
    `source_no`    varchar(255) NOT NULL COMMENT '源单号：可重复，类型不一样',
    `source_type`  int(3)       NOT NULL COMMENT '0-商品购买 1-平台服务费2-渠道服务费 3-分销服务费',
    `writer_id`    int(11)               DEFAULT NULL COMMENT '开票方id',
    `writer`       varchar(255)          DEFAULT NULL COMMENT '开票方',
    `receiver_id`  int(11)               DEFAULT NULL COMMENT '收票方id',
    `receiver`     varchar(255)          DEFAULT NULL COMMENT '收票方',
    `product_info` varchar(255)          DEFAULT NULL COMMENT '商品名称',
    `category_id`  int(2)                DEFAULT NULL COMMENT '商品三级分类id',
    `source_time`  timestamp    NULL     DEFAULT NULL COMMENT '生成时间',
    `quantity`     int(11)               DEFAULT NULL COMMENT '数量',
    `price`        decimal(10, 2)        DEFAULT NULL COMMENT '单价',
    `amount`       decimal(10, 2)        DEFAULT NULL COMMENT '金额',
    `apply_no`     varchar(255)          DEFAULT NULL COMMENT '关联申请单，新增时为空',
    `create_time`  timestamp    NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time`  timestamp    NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='发票源单据';

DROP TABLE IF EXISTS bcx_fapiao_apply;
CREATE TABLE `bcx_fapiao_apply`
(
    `id`              int(11)      NOT NULL AUTO_INCREMENT,
    `apply_no`        varchar(255) NOT NULL COMMENT '申请单号',
    `apply_time`      timestamp    NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '申请时间',
    `writer_id`       int(11)               DEFAULT NULL COMMENT '开票方id',
    `writer`          varchar(255)          DEFAULT NULL COMMENT '开票方',
    `write_time`      timestamp    NULL     DEFAULT NULL COMMENT '开票时间',
    `receiver_id`     int(11)               DEFAULT NULL COMMENT '收票方id',
    `receiver`        varchar(255)          DEFAULT NULL COMMENT '收票方',
    `source_type`     int(3)                DEFAULT NULL COMMENT '费用类型：0-商品购买 1-平台服务费 2-渠道服务费 3-分销服务费',
    `fapiao_no`       varchar(255)          DEFAULT NULL COMMENT '发票号',
    `fapiao_status`   int(2)                DEFAULT NULL COMMENT '状态 0-未开票 1-已开票 2-开票中 3-开票失败',
    `title_type`      int(2)                DEFAULT NULL COMMENT '0-个人 1-企业',
    `fapiao_type`     int(2)                DEFAULT NULL COMMENT '0-增值税普通 1-增值税专用',
    `title`           varchar(255)          DEFAULT NULL COMMENT '发票抬头',
    `fapiao_amount`   decimal(10, 2)        DEFAULT NULL COMMENT '发票金额',
    `tax_no`          varchar(255)          DEFAULT NULL COMMENT '税号',
    `bank_name`       varchar(255)          DEFAULT NULL COMMENT '开户银行',
    `bank_account`    varchar(255)          DEFAULT NULL COMMENT '银行账号',
    `address`         varchar(255)          DEFAULT NULL COMMENT '企业地址',
    `phone`           varchar(15)           DEFAULT NULL COMMENT '企业电话',
    `send_to_name`    varchar(255)          DEFAULT NULL COMMENT '收票人名称',
    `send_to_phone`   varchar(15)           DEFAULT NULL COMMENT '收票人电话',
    `send_to_email`   varchar(255)          DEFAULT NULL COMMENT '收票人email',
    `send_to_address` varchar(255)          DEFAULT NULL COMMENT '收票人地址',
    `reject_reason`   varchar(255)          DEFAULT NULL COMMENT '拒绝原因',
    `vendor_id`       varchar(255)          DEFAULT NULL COMMENT '销方识别号',
    `vendor_name`     varchar(255)          DEFAULT NULL COMMENT '销方名称',
    `fapiao_org`       varchar(255)          DEFAULT NULL COMMENT '发票来源',
    `create_time`     timestamp    NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time`     timestamp    NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='发票申请单';
