package com.zbkj.service.wangshang.api.service.order;

import com.zbkj.service.wangshang.api.MybankApiException;
import com.zbkj.service.wangshang.api.MybankConstants;
import com.zbkj.service.wangshang.api.MybankRequest;
import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.internal.util.XmlUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;


/**
 * Mybank Api: ant.mybank.bkcloudfunds.unifiedorder.traderesult.query
 */
public class BkcloudfundsUnifiedorderTraderesultQueryRequest implements MybankRequest<BkcloudfundsUnifiedorderTraderesultQueryResponse> {

    /**
     * API接口代码
     */
    private final String apiFunction =  "ant.mybank.bkcloudfunds.unifiedorder.traderesult.query";

    /**
     * API接口版本
     */
    private String apiVersion = "1.0.0";

    /**
     * 请求是否需要加签 true/false
     *
     * 默认：true
     */
    private boolean needSign = true;

    /**
     * 请求路由分组
     */
    private String cookieValue;

    /**
     * 公共请求参数（head）
     */
    private RequestHead requestHead;

    /**
     * 业务请求参数（body）
     */
    private RequestBody requestBody;


    public BkcloudfundsUnifiedorderTraderesultQueryRequest (RequestHead requestHead, RequestBody requestBody){
        this.requestHead = requestHead;
        this.requestBody = requestBody;
    }

    /**
     * @param appId 应用ID 由浙江网商银行统一分配,用于识别合作伙伴应用系统，即对端系统编号。联调前线下提供
     */
    public BkcloudfundsUnifiedorderTraderesultQueryRequest (String appId){
        this.requestHead = RequestHead.builder(this.apiVersion, appId, appId, this.apiFunction)
                .inputCharset(MybankConstants.CHARSET_UTF8)
                .reqMsgId(UUID.randomUUID().toString().replace(MybankConstants.CONNECT_SYMBOL_STRING, MybankConstants.NULL_STRING))
                .reqTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern(MybankConstants.DATE_TIME_FORMAT)))
                .reqTimeZone(MybankConstants.DATE_TIMEZONE)
                .reserve(MybankConstants.NULL_STRING)
                .signType(MybankConstants.SIGN_TYPE_RSA)
                .build(); }

    @Override
    public Class<BkcloudfundsUnifiedorderTraderesultQueryResponse> getResponseClass() { return BkcloudfundsUnifiedorderTraderesultQueryResponse.class; }

    @Override
    public String xmlBuild() throws MybankApiException {
        return XmlUtils.requestXmlBuild(this.requestHead, this.requestBody);
    }

    @Override
    public String getApiFunction() {
        return apiFunction;
    }

    @Override
    public String getApiVersion() {
        return apiVersion;
    }

    @Override
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    public boolean isNeedSign() {
        return needSign;
    }

    @Override
    public void setNeedSign(boolean needSign) {
        this.needSign = needSign;
    }

    @Override
    public String getCookieValue() {
        return cookieValue;
    }

    @Override
    public void setCookieValue(String cookieValue) {
        this.cookieValue = cookieValue;
    }

    @Override
    public RequestHead getRequestHead() {
        return requestHead;
    }

    @Override
    public void setRequestHead(RequestHead requestHead) {
        this.requestHead = requestHead;
    }

    @Override
    public RequestBody getRequestBody() {
        return requestBody;
    }

    @Override
    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }
}
