package com.zbkj.service.wangshang.api.internal.util;

import com.zbkj.service.wangshang.api.MybankConstants;

import javax.xml.bind.annotation.adapters.XmlAdapter;

public class CDataAdapter extends XmlAdapter<String, String> {

    @Override
    public String marshal(String v) {
        return MybankConstants.XML_IGNORE_SYMBOL_PREFIX + v + MybankConstants.XML_IGNORE_SYMBOL_SUFFIX;
    }

    @Override
    public String unmarshal(String v) throws IndexOutOfBoundsException {
        if (MybankConstants.XML_IGNORE_SYMBOL.equals(v)) {
            return MybankConstants.NULL_STRING;
        }
        String v1 = null;
        String v2 = null;
        String subStart = MybankConstants.XML_IGNORE_SYMBOL_PREFIX;
        int a = v.indexOf(subStart);
        if (a >= 0) {
            v1 = v.substring(subStart.length(), v.length());
        } else {
            return v;
        }
        String subEnd = MybankConstants.XML_IGNORE_SYMBOL_SUFFIX;
        int b = v1.indexOf(subEnd);
        if (b >= 0) {
            v2 = v1.substring(0, b);
        }
        return v2;
    }

}