package com.zbkj.service.wangshang.api.domain.model.order;

import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 申请代扣支付宝接口<ant.mybank.bkcloudfunds.order.withhold.outasset.apply>
 * 注意点：支付宝代扣到网商， 逆向链路支持退回同主体的其他账户。
 * 请求模型
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsOrderWithholdOutassetApplyRequestModel extends RequestBody {

    private static final long serialVersionUID = 9203037465769549554L;
    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 代扣业务订单号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 业务场景：
     * PLATFORM_CHARGE_COMMON_WALLET：平台代充通用钱包
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Scene")
    private String scene;

    /**
     * 交易金额（分）
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "TotalAmount")
    private String totalAmount;

    /**
     * 币种
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 付款方账号
     * 如果PayeeType = ALIPAY_UID， 则PayerId为支付宝UID；
     * （ 付款方支付宝是需要进行白名单管控，白名单内的ID才允许成功 ）
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PayerId")
    private String payerId;

    /**
     * 付款方类型：
     * ALIPAY_UID：支付宝UID
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PayerType")
    private String payerType;

    /**
     * 收款方账号
     * 钱包：钱包外标
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PayeeId")
    private String payeeId;

    /**
     * 收款方类型
     * COMMON_WALLET：通用钱包账户
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PayeeType")
    private String payeeType;

    /**
     * 收款方户名
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PayeeName")
    private String payeeName;

    /**
     * 备注（可填写订单描述信息
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Memo")
    private String memo;

    /**
     * 扩展信息
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ExtInfo")
    private String extInfo;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getScene() {
        return scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getPayerId() {
        return payerId;
    }

    public void setPayerId(String payerId) {
        this.payerId = payerId;
    }

    public String getPayerType() {
        return payerType;
    }

    public void setPayerType(String payerType) {
        this.payerType = payerType;
    }

    public String getPayeeId() {
        return payeeId;
    }

    public void setPayeeId(String payeeId) {
        this.payeeId = payeeId;
    }

    public String getPayeeType() {
        return payeeType;
    }

    public void setPayeeType(String payeeType) {
        this.payeeType = payeeType;
    }

    public String getPayeeName() {
        return payeeName;
    }

    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }
}