package com.zbkj.service.wangshang.api.domain.model.notify;

import com.zbkj.service.wangshang.api.domain.ResponseBody;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * 协议代扣退款结果通知<ant.mybank.bkcloudfunds.protocol.withhold.refund.result.notify> 1.0.0
 * <p>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class ProtocolWithholdRefundResultNotifyModel extends ResponseBody {
    private static final long serialVersionUID = 6748383778920137715L;

    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 退款参与方类型商户(MERCHANT)、平台(PLATFORM)
     */
    @XmlElement(name = "ParticipantType")
    private String participantType;

    /**
     * 退款参与方id
     * 如果是商户，则填入merchantId,
     * 如果是平台，则填入isvOrgId
     */
    @XmlElement(name = "ParticipantId")
    private String participantId;

    /**
     * 关联网商订单号
     */
    @XmlElement(name = "RelateOrderNo")
    private String relateOrderNo;

    /**
     * 退款网商订单号
     */
    @XmlElement(name = "RefundOrderNo")
    private String refundOrderNo;

    /**
     * 聚合支付渠道退款单号
     */
    @XmlElement(name = "ChannelRefundOrderNo")
    private String channelRefundOrderNo;

    /**
     * 外部退款交易号
     */
    @XmlElement(name = "OutRefundNo")
    private String outRefundNo;

    /**
     * 退款金额。币种同原交易
     */
    @XmlElement(name = "RefundAmount")
    private String refundAmount;

    /**
     *
     */
    @XmlElement(name = "FreezeAmount")
    private String freezeAmount;

    /**
     *
     */
    @XmlElement(name = "AvailableAmount")
    private String availableAmount;

    /**
     * 币种，必须同原交易
     */
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 状态(SUCCESS, FAIL,DEALING)
     */
    @XmlElement(name = "Status")
    private String status;

    /**
     * 商户实际退款金额
     */
    @XmlElement(name = "ParticipantActualRefundAmount")
    private String participantActualRefundAmount;

    /**
     * 退款完成时间（成功时出现）
     */
    @XmlElement(name = "RefundFinishDate")
    private String refundFinishDate;

    /**
     * 错误码
     */
    @XmlElement(name = "ErrorCode")
    private String errorCode;

    /**
     * 错误描述
     */
    @XmlElement(name = "ErrorDesc")
    private String errorDesc;

    /**
     * 扩展信息,Map的json序列化
     */
    @XmlElement(name = "ExtInfo")
    private String extInfo;

    /**
     *
     */
    @XmlElement(name = "RelateTransNo")
    private String relateTransNo;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getParticipantType() {
        return participantType;
    }

    public void setParticipantType(String participantType) {
        this.participantType = participantType;
    }

    public String getParticipantId() {
        return participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public String getRelateOrderNo() {
        return relateOrderNo;
    }

    public void setRelateOrderNo(String relateOrderNo) {
        this.relateOrderNo = relateOrderNo;
    }

    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }

    public String getChannelRefundOrderNo() {
        return channelRefundOrderNo;
    }

    public void setChannelRefundOrderNo(String channelRefundOrderNo) {
        this.channelRefundOrderNo = channelRefundOrderNo;
    }

    public String getOutRefundNo() {
        return outRefundNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public String getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(String refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getFreezeAmount() {
        return freezeAmount;
    }

    public void setFreezeAmount(String freezeAmount) {
        this.freezeAmount = freezeAmount;
    }

    public String getAvailableAmount() {
        return availableAmount;
    }

    public void setAvailableAmount(String availableAmount) {
        this.availableAmount = availableAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getParticipantActualRefundAmount() {
        return participantActualRefundAmount;
    }

    public void setParticipantActualRefundAmount(String participantActualRefundAmount) {
        this.participantActualRefundAmount = participantActualRefundAmount;
    }

    public String getRefundFinishDate() {
        return refundFinishDate;
    }

    public void setRefundFinishDate(String refundFinishDate) {
        this.refundFinishDate = refundFinishDate;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDesc() {
        return errorDesc;
    }

    public void setErrorDesc(String errorDesc) {
        this.errorDesc = errorDesc;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public String getRelateTransNo() {
        return relateTransNo;
    }

    public void setRelateTransNo(String relateTransNo) {
        this.relateTransNo = relateTransNo;
    }
}
