package com.zbkj.service.wangshang.api.domain.model.notify;


import com.zbkj.service.wangshang.api.domain.ResponseBody;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * 商户修改结果通知（异步通知接口）< ant.mybank.merchantprod.merch.async.updateMerchant.notify>
 * <p>
 * 开户结果异步通知
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class MerchantprodMerchAsyncUpdateMerchantNotifyModel extends ResponseBody {

    private static final long serialVersionUID = -3264596667211388155L;
    /**
     * 外部商户号
     */
    @XmlElement(name = "OutMerchantId")
    private String outMerchantId;

    /**
     * 申请单号
     */
    @XmlElement(name = "OrderNo")
    private String orderNo;

    /**
     * 商户号
     * <p>
     * 网商为商户分配的商户号，通过商户入驻结果查询接口获取。
     */
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 修改结果
     * 可选值：
     * 1：成功
     * 2：失败
     */
    @XmlElement(name = "Status")
    private String status;

    /**
     * 外部交易号
     */
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 错误码
     */
    @XmlElement(name = "ErrorCode")
    private String errorCode;

    /**
     * 户失败原因返回。当商户开户结果为失败时返回。可能出现的失败原因描述见附录。
     */
    @XmlElement(name = "FailReason")
    private String failReason;

    public String getOutMerchantId() {
        return outMerchantId;
    }

    public void setOutMerchantId(String outMerchantId) {
        this.outMerchantId = outMerchantId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getFailReason() {
        return failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
}