package com.zbkj.service.wangshang.api.domain.model.notify;


import com.zbkj.service.wangshang.api.domain.ResponseBody;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * 来帐汇入通知接口（异步接口）<ant.mybank.bkcloudfunds.vostro.notify>
 * <p>
 * 收款账号接收到汇入的来账信息后，无论校验（收款姓名、白名单、金额等校验）是否通过，均会通知平台。
 * 应答结果不为成功时，会重复通知。平台根据通知的交易状态做后续处理。如：入账成功，则本地记账。 入账失败，则通知客户转账失败原因，便于客户重新转账。线下联系联调人员单独配置此接口的通知地址。
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsVostroNotifyModel extends ResponseBody {

    private static final long serialVersionUID = -7229087145547322914L;
    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 商户号
     * 网商为商户分配的商户号，通过商户入驻结果查询接口获取。作为收款方账号
     */
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 外部交易号
     */
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 网商支付订单号
     */
    @XmlElement(name = "OrderNo")
    private String orderNo;

    /**
     * 入账流水号
     * 如创建订单类型type为02，此处为单笔入账操作流水号，后续用于退款服务
     */
    @XmlElement(name = "TransNo")
    private String transNo;

    /**
     * 出款渠道id（9001大额、9002小额、9003超网、9100支付宝）
     */
    @XmlElement(name = "ChannelId")
    private String channelId;

    /**
     * 付款方银行联行号
     */
    @XmlElement(name = "PayerBankOrgId")
    private String payerBankOrgId;

    /**
     * 付款方卡号
     */
    @XmlElement(name = "PayerCardNo")
    private String payerCardNo;

    /**
     * 付款方卡号户名
     */
    @XmlElement(name = "PayerCardName")
    private String payerCardName;

    /**
     * 收款方卡号
     */
    @XmlElement(name = "PayeeCardNo")
    private String payeeCardNo;

    /**
     * 收款方卡号户名
     */
    @XmlElement(name = "PayeeCardName")
    private String payeeCardName;

    /**
     * 订单金额(金额为分)
     * 如创建订单类型type为02，此处为单笔入账金额
     */
    @XmlElement(name = "TotalAmount")
    private String totalAmount;

    /**
     * 币种，默认CNY
     */
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 转账时间
     */
    @XmlElement(name = "TransferDate")
    private String transferDate;

    /**
     * 备注
     */
    @XmlElement(name = "Memo")
    private String memo;

    /**
     * 扩展信息 Map<String,String>的Json格式  base64编码
     */
    @XmlElement(name = "ExtInfo")
    private String extInfo;

    /**
     * 状态 SUCCESS/FAIL/DEALING
     */
    @XmlElement(name = "Status")
    private String status;

    /**
     * 来账类型
     * ORDER_VOSTRO：订单码支付
     * ACCOUNT_VOSTRO：外标户支付
     */
    @XmlElement(name = "VostroType")
    private String vostroType;

    /**
     * 来账场景
     * PRE_CHARGE： 预充
     * PRE_PAY：预付
     */
    @XmlElement(name = "VostroScene")
    private String vostroScene;

    /**
     * 备注信息
     */
    @XmlElement(name = "Remark")
    private String remark;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTransNo() {
        return transNo;
    }

    public void setTransNo(String transNo) {
        this.transNo = transNo;
    }

    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getPayerBankOrgId() {
        return payerBankOrgId;
    }

    public void setPayerBankOrgId(String payerBankOrgId) {
        this.payerBankOrgId = payerBankOrgId;
    }

    public String getPayerCardNo() {
        return payerCardNo;
    }

    public void setPayerCardNo(String payerCardNo) {
        this.payerCardNo = payerCardNo;
    }

    public String getPayerCardName() {
        return payerCardName;
    }

    public void setPayerCardName(String payerCardName) {
        this.payerCardName = payerCardName;
    }

    public String getPayeeCardNo() {
        return payeeCardNo;
    }

    public void setPayeeCardNo(String payeeCardNo) {
        this.payeeCardNo = payeeCardNo;
    }

    public String getPayeeCardName() {
        return payeeCardName;
    }

    public void setPayeeCardName(String payeeCardName) {
        this.payeeCardName = payeeCardName;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getTransferDate() {
        return transferDate;
    }

    public void setTransferDate(String transferDate) {
        this.transferDate = transferDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getExtInfo() {
        return extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getVostroType() {
        return vostroType;
    }

    public void setVostroType(String vostroType) {
        this.vostroType = vostroType;
    }

    public String getVostroScene() {
        return vostroScene;
    }

    public void setVostroScene(String vostroScene) {
        this.vostroScene = vostroScene;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}