package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;
import com.zbkj.service.wangshang.api.domain.RequestBody;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 协议代扣退款申请接口<ant.mybank.bkcloudfunds.protocol.withhold.refund.apply>
 * 请求模型
 * <p>
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class ProtocolWithholdRefundApplyRequestModel extends RequestBody {
    private static final long serialVersionUID = -6826910626433434488L;

    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 退款付方类型，即原支付单收方
     *   商户(MERCHANT)、 平台(PLATFORM)
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ParticipantType")
    private String participantType;

    /**
     * 退款付方id，即原支付单收方
     *   如果是商户，则填入merchantId,
     * 如果是平台，则填入isvOrgId
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ParticipantId")
    private String participantId;

    /**
     * 关联网商订单号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "RelateOrderNo")
    private String relateOrderNo;

    /**
     * 关联网商支付流水号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "RelateTransNo")
    private String relateTransNo;

    /**
     * 退款外部交易号。由合作方生成，同笔退款交易，交易状态未明需要重试时，使用同一个交易号。
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutRefundNo")
    private String outRefundNo;

    /**
     * 订单退款金额。向渠道退款金额。
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "RefundAmount")
    private String refundAmount;

    /**
     * 币种，必须同原交易
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 退款原因
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "RefundReason")
    private String refundReason;

    /**
     * 扩展信息
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ExtraInfo")
    private String extraInfo;

    /**
     * 备注
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Memo")
    private String memo;

    public String getIsvOrgId() {return isvOrgId;}
    public void setIsvOrgId(String isvOrgId) {this.isvOrgId = isvOrgId;}

    public String getParticipantType() {return participantType;}
    public void setParticipantType(String participantType) {this.participantType = participantType;}

    public String getParticipantId() {return participantId;}
    public void setParticipantId(String participantId) {this.participantId = participantId;}

    public String getRelateOrderNo() {return relateOrderNo;}
    public void setRelateOrderNo(String relateOrderNo) {this.relateOrderNo = relateOrderNo;}

    public String getRelateTransNo() {return relateTransNo;}
    public void setRelateTransNo(String relateTransNo) {this.relateTransNo = relateTransNo;}

    public String getOutRefundNo() {return outRefundNo;}
    public void setOutRefundNo(String outRefundNo) {this.outRefundNo = outRefundNo;}

    public String getRefundAmount() {return refundAmount;}
    public void setRefundAmount(String refundAmount) {this.refundAmount = refundAmount;}

    public String getCurrency() {return currency;}
    public void setCurrency(String currency) {this.currency = currency;}

    public String getRefundReason() {return refundReason;}
    public void setRefundReason(String refundReason) {this.refundReason = refundReason;}

    public String getExtraInfo() {return extraInfo;}
    public void setExtraInfo(String extraInfo) {this.extraInfo = extraInfo;}

    public String getMemo() {return memo;}
    public void setMemo(String memo) {this.memo = memo;}
}
