package com.zbkj.service.wangshang.api.domain.model;


import com.zbkj.service.wangshang.api.MybankObject;
import com.zbkj.service.wangshang.api.domain.RespInfo;

import javax.xml.bind.annotation.*;

/**
 * 商户信息查询接口<ant.mybank.merchantprod.merch.query>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class MerchantprodMerchQueryResponseModel extends MybankObject {

    private static final long serialVersionUID = 9166867143201719018L;
    /**
     * 返回码组件
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 商户名称
     * <p>
     * 有营业执照的，要求与营业执照上的名称一致。
     */
    @XmlElement(name = "MerchantName")
    private String merchantName;

    /**
     * 商户号
     * <p>
     * 网商为商户分配的商户号，通过商户入驻结果查询接口获取。
     */
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 商户类型 可选值： 01:自然人; 02:个体工商户; 03:企业商户
     */
    @XmlElement(name = "MerchantType")
    private String merchantType;

    /**
     * 商户经营类型。可选值： 01:实体特约商户; 02:网络特约商户; 03:实体兼网络特约商户
     */
    @XmlElement(name = "DealType")
    private String dealType;

    /**
     * 商户详情列表
     * <p>
     * json格式base64编码，具体报文定义参考商户详情
     */
    @XmlElement(name = "MerchantDetail")
    private String merchantDetail;

    /**
     * 清算卡参数
     * <p>
     * json格式base64编码，具体报文定义参考下面的清算卡，仅结算方式为“01结算到他行卡”需要填写
     */
    @XmlElement(name = "BankCardParam")
    private String bankCardParam;

    /**
     * 商户认证信息
     * <p>
     * 包括（认证类型，认证状态，失败原因）json格式Base64 编码
     * AuthStatus：FAIL、PASS AuthType：OCR_AUTH Remark：提示信息
     * SubAuthType：01-身份证正面；02-身份证反面；03-营业执照
     */
    @XmlElement(name = "AuthList")
    private String authList;

    /**
     * 支持支付渠道列表
     */
    @XmlElement(name = "PayChannelList")
    private String payChannelList;

    /**
     * 直付通信息
     */
    @XmlElement(name = "ZftAlipayInfo")
    private String zftAlipayInfo;

    /**
     * 直付通开票信息
     */
    @XmlElement(name = "InvoiceInfo")
    private String invoiceInfo;

    public RespInfo getRespInfo() {
        return respInfo;
    }

    public void setRespInfo(RespInfo respInfo) {
        this.respInfo = respInfo;
    }

    public String getMerchantName() {
        return merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getMerchantType() {
        return merchantType;
    }

    public void setMerchantType(String merchantType) {
        this.merchantType = merchantType;
    }

    public String getDealType() {
        return dealType;
    }

    public void setDealType(String dealType) {
        this.dealType = dealType;
    }

    public String getMerchantDetail() {
        return merchantDetail;
    }

    public void setMerchantDetail(String merchantDetail) {
        this.merchantDetail = merchantDetail;
    }

    public String getBankCardParam() {
        return bankCardParam;
    }

    public void setBankCardParam(String bankCardParam) {
        this.bankCardParam = bankCardParam;
    }

    public String getAuthList() {
        return authList;
    }

    public void setAuthList(String authList) {
        this.authList = authList;
    }

    public String getPayChannelList() { return payChannelList; }
    public void setPayChannelList(String payChannelList) { this.payChannelList = payChannelList; }

    public String getZftAlipayInfo() { return zftAlipayInfo; }
    public void setZftAlipayInfo(String zftAlipayInfo) { this.zftAlipayInfo = zftAlipayInfo; }

    public String getInvoiceInfo() { return invoiceInfo; }
    public void setInvoiceInfo(String invoiceInfo) { this.invoiceInfo = invoiceInfo; }
}