package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.MybankObject;
import com.zbkj.service.wangshang.api.domain.RespInfo;

import javax.xml.bind.annotation.*;

/**
 * 行业小程序创单（普通单&合并单）接口 <ant.mybank.bkcloudfunds.unifiedorder.create>
 * 响应模型
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsUnifiedOrderCreateResponseModel extends MybankObject {

    private static final long serialVersionUID = 8157761966662140174L;

    /**
     * 返回码组件
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 业务交易订单号
     */
    @XmlElement(name = "OrderNo")
    private String orderNo;

    /**
     * 原外部订单请求流水号
     */
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    public RespInfo getRespInfo() {
        return respInfo;
    }

    public void setRespInfo(RespInfo respInfo) {
        this.respInfo = respInfo;
    }

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }
}