package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 支付退回查询接口< ant.mybank.bkcloudfunds.refund.query>
 * 请求模型
 * <p>
 * 通过此查询接口，针对某笔支付退回交易进行单笔查询
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsRefundQueryRequestModel extends RequestBody {

    private static final long serialVersionUID = 1346024505303905152L;
    /**
     * 合作方机构号
     * <p>
     * 网商银行分配
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 关联网商订单号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "RelateOrderNo")
    private String relateOrderNo;

    /**
     * 退款参与方类型，即原支付单收方, 商户(MERCHANT)、 平台(PLATFORM)、子户汇入（SUBACCOUNT）
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ParticipantType")
    private String participantType;

    /**
     * 退款付方id，即原支付单收方
     * <p>
     * 如果是商户，则填入merchantId,
     * 如果是平台，则填入isvOrgId,
     * 如果是子户汇入，则填入汇入子户外标
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ParticipantId")
    private String participantId;

    /**
     * 退款外部交易号
     * <p>
     * 由合作方生成，同笔退款交易，交易状态未明需要重试时，使用同一个交易号。
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutRefundNo")
    private String outRefundNo;

    /**
     * 网商退款订单号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "RefundOrderNo")
    private String refundOrderNo;

    public String getIsvOrgId() {
        return isvOrgId;
    }

    public void setIsvOrgId(String isvOrgId) {
        this.isvOrgId = isvOrgId;
    }

    public String getRelateOrderNo() {
        return relateOrderNo;
    }

    public void setRelateOrderNo(String relateOrderNo) {
        this.relateOrderNo = relateOrderNo;
    }

    public String getParticipantType() {
        return participantType;
    }

    public void setParticipantType(String participantType) {
        this.participantType = participantType;
    }

    public String getParticipantId() {
        return participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public String getOutRefundNo() {
        return outRefundNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public String getRefundOrderNo() {
        return refundOrderNo;
    }

    public void setRefundOrderNo(String refundOrderNo) {
        this.refundOrderNo = refundOrderNo;
    }
}